/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_default_port.c 11482 2008-01-04 20:37:41Z foucher $";

#ifndef winnt
#include <netinet/in.h>
#include <netdb.h>  /* servent on solaris */
#endif

#define GTX_DEFAULT_PORT 5500

/*!
******************************************************************************
\brief Get the default port for GTXserver

When the GTXserver is ran without argument, it runs on a default port. This
default port is taken from the local /etc/services file using getservbyname
with the service name equal to "GTXserver". If not found in the services file,
it defaults to a hard-coded value.

\return port: default GTXserver port

\par Remarks: This function replaces the define GTX_DEFAULT_PORT used in
previous GTXserver versions.

\par Remarks: The returned value may be used as an initial value for the port
in the user interface asking parameters for connection on an already running
server.
*****************************************************************************/
unsigned short GTXClientGetDefaultPort(void)
{
  struct servent *srv;
  unsigned short port;

  GTX_TRACE_FUNC_START("GTXClientGetDefaultPort",0);
  /* Get service by name is not specified */
#ifndef winnt
  setservent(0);
#endif
  GTX_TRACE(2,("Getting Default port from services"));
  srv = getservbyname("GTXserver", NULL);
  if (srv == NULL)
  {
    port = GTX_DEFAULT_PORT;
    GTX_TRACE(2,("Not found, using default port"));
  }
  else
    port = ntohs(srv->s_port);
#ifndef winnt
  endservent();
#endif
  GTX_TRACE_FUNC_END("%d",port);
  return(port);
}
