/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_dir_list.c 26586 2016-10-21 15:08:13Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Get the list of directories in the current study

This function retrieve, from the GTXserver, the list of available
directories in the current study. 
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval nb_dir Number of directories in the current study
\retval directories Array of directory names

\par Remarks:
Directories must be freed using
\code
directories = GTXClientFreeStringArray(nb_dir, directories);
\endcode
*****************************************************************************/
int GTXClientGetDirectoryList(int *nb_dir, char ***directories)
{
  GTXErrorCode error;
  char answer[10];
  int i;

  GTX_TRACE_FUNC_START("GTXClientGetDirectoryList",1);
  GTX_TRACE(1, ("(%p,%p)",nb_dir,directories));

  *nb_dir = 0;
  *directories = NULL;

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CDIRLST") ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDIRS") ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if( !_gtx_read_int(_gtx_server_socket, nb_dir) ) goto label_end;

  error = GTX_ERROR_MEMORY;
  *directories = (char**)malloc(sizeof(char*) * *nb_dir);
  if( *directories == NULL ) goto label_end;

  error = GTX_ERROR_NETWORK;
  for(i=0; i<*nb_dir; i++) (*directories)[i] = NULL;
  for(i=0; i<*nb_dir; i++)
    if( !_gtx_read_string(_gtx_server_socket, &((*directories)[i]), 10000) )
      goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if( error )
  {
    *directories = GTXClientFreeStringArray(*nb_dir, *directories);
    *nb_dir = 0;
    _gtx_cleanup_socket();
  }
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Check if a given directory exists

This function asks the server if a given directory exists (or for old servers, it
retrieves the list of directorys and check it by itself).
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param directory_name directory name to check
\retval exists 0 if it does not exists, 1 if it exists
*****************************************************************************/
int GTXClientDirectoryExists(const char *directory_name, int *exists)
{
  GTXErrorCode error;
  char answer[10];

  GTX_TRACE_FUNC_START("GTXClientDirectoryExists",1);
  GTX_TRACE(1, ("(%s,%p)", directory_name, exists));
  *exists = 0;
  if (!_gtx_is_supported("CDIRXIST",0))
  {
    char **dirs = NULL;
    int i,nb_dir;
    error = (GTXErrorCode)GTXClientGetDirectoryList(&nb_dir,&dirs);
    if (!error)
    {
      for (i = 0; i < nb_dir && !*exists; i++)
        if (!strcmp(dirs[i], directory_name))
          *exists = 1;
      dirs = GTXClientFreeStringArray(nb_dir, dirs);
    }
    goto label_end;
  }

  error = GTX_ERROR_NETWORK;
  if (_gtx_start_packet("CDIRXIST")) goto label_end;

  if (!_gtx_write_string(_gtx_server_socket, &directory_name, 10000))
    goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SEXIST")) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_read_int(_gtx_server_socket, exists)) goto label_end;

  error = GTX_ERROR_NONE;
label_end:
  if (error)
    _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
