/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_file_info.c 22831 2013-09-16 10:14:00Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Get information about current file

This function retrieve, from the GTXserver, the information about
the current file. 
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval file_info The information about current file

\par Remarks:
All coordinates are returned in the current unit (\ref GTXClientSetUnit) or
using the corresponding coordinate variable unit if unit_mode is set to 1
(\ref GTXClientSetUnitMode).
*****************************************************************************/
int GTXClientGetFileInfo(GTXFileInfo *file_info)
{
  GTXErrorCode error;
  char *s[1];
  char answer[10];
  GTXFaultInfo *fault_info;

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientGetFileInfo",1);
  GTX_TRACE(1, ("(%p)", file_info));
  if( _gtx_start_packet("CFILEINFO") ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SFILEINFO") ) goto label_end;

  error = GTX_ERROR_NETWORK;

  s[0] = file_info->linked_file;
  if( !_gtx_read_int(_gtx_server_socket, (int*)&file_info->type) ||
      !_gtx_read_string(_gtx_server_socket, s, 50) ||
      !_gtx_read_bool(_gtx_server_socket, &file_info->faulted) ||
      !_gtx_read_bool(_gtx_server_socket, &file_info->polygon_file) ||
      !_gtx_read_int(_gtx_server_socket, &file_info->dimension) ||
      !_gtx_read_long(_gtx_server_socket, &file_info->s_number) ||
      !_gtx_read_int(_gtx_server_socket, &file_info->item_number) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->X0) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->Y0) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->Z0) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->DX) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->DY) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->DZ) ||
      !_gtx_read_int(_gtx_server_socket, &file_info->NX) ||
      !_gtx_read_int(_gtx_server_socket, &file_info->NY) ||
      !_gtx_read_int(_gtx_server_socket, &file_info->NZ) ||
      !_gtx_read_bool(_gtx_server_socket, &file_info->rotation) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->angle_z) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->angle_y) ||
      !_gtx_read_double(_gtx_server_socket, &file_info->angle_x) )
    goto label_end;

  /* read special variable names */
  s[0] = file_info->sn_var_name;
  if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
  s[0] = file_info->ln_var_name;
  if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
  s[0] = file_info->rn_var_name;
  if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
  s[0] = file_info->xg_var_name;
  if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
  s[0] = file_info->yg_var_name;
  if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
  s[0] = file_info->zg_var_name;
  if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;

  (void)strcpy(file_info->xb_var_name, "");
  (void)strcpy(file_info->yb_var_name, "");
  (void)strcpy(file_info->zb_var_name, "");
  (void)strcpy(file_info->xe_var_name, "");
  (void)strcpy(file_info->ye_var_name, "");
  (void)strcpy(file_info->ze_var_name, "");

  /* Fix file type for old servers */
  if (_gtx_client_server_version < 900000)
  {
    if ((int)file_info->type == 3)
      file_info->type = GTX_FILE_TYPE_GRID;
    else if ((int)file_info->type > 3)
      file_info->type = GTX_FILE_TYPE_INVALID;
  }
  /* if new server & core lines, read new core lines info */
  else if (file_info->type == GTX_FILE_TYPE_CORE_LINES)
  {
    s[0] = file_info->xb_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
    s[0] = file_info->yb_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
    s[0] = file_info->zb_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
    s[0] = file_info->xe_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
    s[0] = file_info->ye_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
    s[0] = file_info->ze_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
    
  }
  (void)strcpy(file_info->lname_var_name, "");
  if (_gtx_client_server_version >= 1300030)
  {
    s[0] = file_info->lname_var_name;
    if( !_gtx_read_string(_gtx_server_socket, s, 50) ) goto label_end;
  }

  /* Read fault information */
  fault_info = &file_info->fault_info;
  if( !_gtx_read_int(_gtx_server_socket, &fault_info->faults_2d) ||
      !_gtx_read_bool(_gtx_server_socket, &fault_info->aux_var_used) ||
      !_gtx_read_int(_gtx_server_socket, &fault_info->faults_number) ||
      !_gtx_read_int(_gtx_server_socket, &fault_info->segments_number) ||
      !_gtx_read_int(_gtx_server_socket, &fault_info->min_fpriority) ||
      !_gtx_read_int(_gtx_server_socket, &fault_info->max_fpriority) ||
      !_gtx_read_int(_gtx_server_socket, &fault_info->auth_priority))
    goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if( error )
  {
    file_info->type = GTX_FILE_TYPE_INVALID;
    _gtx_cleanup_socket();
  }

  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/****************************************************************************
**
** FUNCTION: _gtx_get_line_samples
**
** PURPOSE:  Retrieves the number of samples per line
**
** RETURNS:  GTXErrorCode
**
** OUT_ARGS:  nlines: number of lines
** OUT_ARGS:  scount: array of number of samples per line
**
*****************************************************************************/
GTXErrorCode _gtx_get_line_samples(int *nlines,
                                   int **scount)
{
  GTXErrorCode error;
  char answer[10];

  GTX_TRACE_FUNC_START("_gtx_get_line_samples",1);
  GTX_TRACE(1, ("(%p,%p)",nlines,scount));

  *nlines = 0;
  *scount = NULL;

  error = GTX_ERROR_NETWORK;
  if (_gtx_is_supported("CLFILECNT", 0))
  {
    if (_gtx_start_packet("CLFILECNT")) goto label_end;

    if (_gtx_send_and_wait(answer)) goto label_end;

    error = GTX_ERROR_SERVER;
    if (_gtx_check_answer(answer, "SLFILECNT")) goto label_end;

    if (!_gtx_read_int(_gtx_server_socket, nlines)) goto label_end;

    error = GTX_ERROR_MEMORY;
    *scount = malloc(sizeof(int)*(*nlines));
    if (*scount == NULL) goto label_end;
    if (!_gtx_rw_vector(_gtx_server_socket, (char*)*scount, *nlines,
                        sizeof(int), (_gtx_proc_rw_t)_gtx_read_int))
      goto label_end;
  }

  error = GTX_ERROR_NONE;
label_end:
  GTX_TRACE_FUNC_END("%d",error);
  return (GTXErrorCode)(error != GTX_ERROR_NONE);
  
}
