/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_macro_indices.c 18576 2011-05-16 09:33:31Z meric $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Get the list of available indices for the current macro variable

This function retrieve, from the GTXserver, the list of available
indices for the current macro variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval nb_indice Number of indices for the current macro variable
\retval indices Array of available indices for the current macro variable

\par Remarks:
Indices must be freed using
\code
indices = GTXClientFreePointer(indices)
\endcode
*****************************************************************************/
int GTXClientGetMacroIndices(int *nb_indice, int **indices)
{
  GTXErrorCode error;
  char answer[10];

  GTX_TRACE_FUNC_START("GTXClientGetMacroIndices",1);
  GTX_TRACE(1, ("(%p,%p)", nb_indice, indices));
  *nb_indice = 0;
  *indices = NULL;

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CMACROIND") ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SMACROIND") ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if( !_gtx_read_int(_gtx_server_socket, nb_indice) ) goto label_end;

  error = GTX_ERROR_MEMORY;
  *indices = (int*)malloc(sizeof(int) * *nb_indice);
  if( *indices == NULL ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_rw_vector(_gtx_server_socket, (char*)*indices, *nb_indice,
                      sizeof(int), (_gtx_proc_rw_t)_gtx_read_int))
    goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if( error )
  {
    *indices = GTXClientFreePointer(*indices);
    *nb_indice = 0;
    _gtx_cleanup_socket();
  }
    
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Get the list of available indices for the current macro variable with
the corresponding alphanumerical indices.

This function retrieves, from the GTXserver, the list of available
indices (and alpha indices) for the current macro variable. Alphanumerical
indices are created for some macro variables like QTMs or Lithotypes.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval nb_indice Number of indices for the current macro variable
\retval indices Array of available indices for the current macro variable
\retval alpha_indices Array of available alphanumerical indices for the
current macro variable. alpha_indices can be returned NULL if macro has no
alpha indices.

\par Remarks:
Indices must be freed using
\code
indices = GTXClientFreePointer(indices)
alpha_indices = GTXClientFreeStringArray(nb_indices,alpha_indices)
\endcode
*****************************************************************************/
int GTXClientGetMacroIndicesWithAlpha(int *nb_indice,
                                      int **indices,
                                      char ***alpha_indices)
{
  int i;
  GTXErrorCode error;
  char answer[10];

  GTX_TRACE_FUNC_START("GTXClientGetMacroIndicesWithAlpha",1);
  GTX_TRACE(1, ("(%p,%p,%p)", nb_indice, indices,alpha_indices));
  *nb_indice = 0;
  *indices = NULL;
  *alpha_indices = NULL;

  if (!_gtx_is_supported("CMACROALP",0))
  {
    error = (GTXErrorCode)GTXClientGetMacroIndices(nb_indice, indices);
    goto label_end;
  }

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CMACROALP") ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SMACROALP") ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if( !_gtx_read_int(_gtx_server_socket, nb_indice) ) goto label_end;

  error = GTX_ERROR_MEMORY;
  *indices = (int*)malloc(sizeof(int) * *nb_indice);
  if( *indices == NULL ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_rw_vector(_gtx_server_socket, (char*)*indices, *nb_indice,
                      sizeof(int), (_gtx_proc_rw_t)_gtx_read_int))
    goto label_end;

  i = (alpha_indices != NULL);
  if (!_gtx_read_int(_gtx_server_socket, &i)) goto label_end; /* alpha? */
  if (i)
  {
    error = GTX_ERROR_MEMORY;
    *alpha_indices = (char **)malloc(sizeof(char*) * (*nb_indice));
    if (*alpha_indices == NULL) goto label_end;

    error = GTX_ERROR_NETWORK;
    for(i = 0; i < *nb_indice; i++) (*alpha_indices)[i] = NULL;
    for (i = 0; i < *nb_indice; i++)
    {
      if (!_gtx_read_string(_gtx_server_socket,
                            &((*alpha_indices)[i]), 10000)) goto label_end;
    }
  }
  error = GTX_ERROR_NONE;

label_end:
  if (error)
  {
    *indices = GTXClientFreePointer(*indices);
    *alpha_indices = GTXClientFreeStringArray(*nb_indice,*alpha_indices);
    *nb_indice = 0;
    _gtx_cleanup_socket();
  }
    
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
