/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_polygons.c 11624 2008-01-18 18:30:56Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Get current file as polygon system (if possible)

This function retrieve, from the GTXserver, the polygon system
associated to the current file.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval polygon_system Polygon system associated to the current file

\par Remarks:
All coordinates are returned in the current unit (\ref GTXClientSetUnit) or
using the corresponding coordinate variable unit if unit_mode is set to 1
(\ref GTXClientSetUnitMode).

Some memory is allocated inside passed polygon_system. Memory must be freed
using GTXClientFreePolygons.
*****************************************************************************/
int GTXClientReadPolygons(GTXPolygonSystem *polygon_system)
{
  char *s1[1];
  char *s2[1];
  gtx_long i;
  GTXErrorCode error;
  char answer[10];
  GTXPolygon *poly;

  GTX_TRACE_FUNC_START("GTXClientReadPolygons",1);
  GTX_TRACE(1, ("(%p)", polygon_system));
  polygon_system->polygons = NULL;
  polygon_system->n_polygons = 0;

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CPOLYGONS") ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SPOLYGONS") ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if( !_gtx_read_bool(_gtx_server_socket, &polygon_system->polygons_2d) ||
      !_gtx_read_double(_gtx_server_socket, &polygon_system->ext_min[0]) ||
      !_gtx_read_double(_gtx_server_socket, &polygon_system->ext_min[1]) ||
      !_gtx_read_double(_gtx_server_socket, &polygon_system->ext_min[2]) ||
      !_gtx_read_double(_gtx_server_socket, &polygon_system->ext_max[0]) ||
      !_gtx_read_double(_gtx_server_socket, &polygon_system->ext_max[1]) ||
      !_gtx_read_double(_gtx_server_socket, &polygon_system->ext_max[2]) ||
      !_gtx_read_long(_gtx_server_socket, &polygon_system->n_polygons) )
    goto label_end;

  error = GTX_ERROR_MEMORY;
  polygon_system->polygons = (GTXPolygon*)malloc(sizeof(GTXPolygon) * polygon_system->n_polygons);
  if( polygon_system->polygons == NULL ) goto label_end;

  error = GTX_ERROR_NETWORK;
  poly = polygon_system->polygons;
  for(i=0; i<polygon_system->n_polygons; i++, poly++)
  {
    s1[0] = poly->name;
    s2[0] = poly->group_name;
    if( !_gtx_read_string(_gtx_server_socket, s1, 16) ||
        !_gtx_read_string(_gtx_server_socket, s2, 16) ||
        !_gtx_read_double(_gtx_server_socket, &poly->z_min) ||
        !_gtx_read_double(_gtx_server_socket, &poly->z_max) ||
        !_gtx_read_int(_gtx_server_socket, &poly->n_vertices) )
      goto label_end;

    error = GTX_ERROR_MEMORY;
    poly->vertices = (double*)malloc(sizeof(double) * poly->n_vertices * 2);
    if( poly->vertices == NULL ) goto label_end;

    error = GTX_ERROR_NETWORK;
    if (!_gtx_rw_vector(_gtx_server_socket, (char*)poly->vertices,
                        poly->n_vertices*2,
                        sizeof(double), (_gtx_proc_rw_t)_gtx_read_double))
      goto label_end;
  } /* end of loop on polygons */

  error = GTX_ERROR_NONE;

label_end:
  if( error )
  {
    GTXClientFreePolygons(polygon_system);
    _gtx_cleanup_socket();
  }

  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Frees memory allocated in the polygon system

This function frees the memory allocated by a previous call to
GTXClientReadPolygons
\param polygon_system Polygon system to be freed

\par Remarks:
This function is meant to only free memory allocated by GTXClientReadPolygons.
Only call this function AFTER a call to GTXClientReadPolygons. Elsewhere
memory in the polygons system is not initialized and an attempt to free it
could cause problems.
Indeed this function frees polygon_system->polygons so if you may call this
function before read, first initialize polygons to NULL.
*****************************************************************************/
void GTXClientFreePolygons(GTXPolygonSystem *polygon_system)
{
  gtx_long i;
  GTX_TRACE_FUNC_START("GTXClientFreePolygons",1);
  GTX_TRACE(1, ("(%p)", polygon_system));
  if (polygon_system->polygons)
  {
    for (i = 0; i < polygon_system->n_polygons; i++)
    {
      if (polygon_system->polygons[i].vertices)
        free(polygon_system->polygons[i].vertices);
    }
    free(polygon_system->polygons);
    polygon_system->polygons = NULL;
  }
  polygon_system->n_polygons = 0;
  GTX_TRACE_FUNC_END(NULL,NULL);
}

/*!
******************************************************************************
\brief Copies a given Fault
 
This function copies a Polygon
\retval polygon_out new copy of the Polygon
\param polygon_in original Polygon
*****************************************************************************/
void GTXClientPolygonDuplicate(const GTXPolygon *polygon_in,
                               GTXPolygon *polygon_out)
{
  int i;

  strcpy(polygon_out->name,polygon_in->name);
  strcpy(polygon_out->group_name,polygon_in->group_name);
  polygon_out->z_min = polygon_in->z_min;
  polygon_out->z_max = polygon_in->z_max;
  polygon_out->n_vertices = polygon_in->n_vertices;

  polygon_out->vertices = malloc(2 * polygon_out->n_vertices * sizeof(double));
  for (i = 0; i<  2*polygon_out->n_vertices; i++)
    polygon_out->vertices[i] = polygon_in->vertices[i];
}

/*!
******************************************************************************
\brief Copies a given Fault
 
This function copies a Polygon
\retval polysys_out new copy of the Polygon
\param polysys_in original Polygon
*****************************************************************************/
void GTXClientPolygonSystemDuplicate(const GTXPolygonSystem *polysys_in,
                                     GTXPolygonSystem *polysys_out)
{
  int i;

  polysys_out->polygons_2d = polysys_in->polygons_2d;
  polysys_out->n_polygons = polysys_in->n_polygons;

  for (i = 0; i<3; i++)
    polysys_out->ext_min[i] = polysys_in->ext_min[i];

  for (i = 0; i<3; i++)
    polysys_out->ext_max[i] = polysys_in->ext_max[i];
  
  polysys_out->polygons = malloc(polysys_out->n_polygons * sizeof(GTXPolygon_C));
  for (i = 0; i < polysys_out->n_polygons; i++)
    GTXClientPolygonDuplicate(&polysys_in->polygons[i],
                              &polysys_out->polygons[i]);
}
