/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_var_info.c 12705 2008-07-02 15:14:34Z martin $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Get the current variable information

This function retrieve, from the GTXserver, the information about the
current variable. If used on a length variable, information will be returned
using the current default unit (\ref GTXClientSetUnit) or in the variable unit
if current unit mode is 1 (\ref GTXClientSetUnitMode).
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval var_info The current variable information

\par Remarks:
On a length variable, by default, the returned unit is the current unit
(\ref GTXClientSetUnit). If you want to get its real unit, you must set
unit_mode to 1 before (\ref GTXClientSetUnitMode).
*****************************************************************************/
int GTXClientGetVariableInfo(GTXVariableInfo *var_info)
{
  GTXErrorCode error;
  char *s[1];
  char answer[10];
  char unit_factor[11];
  char unit_symbol[11];
  int unit_length;

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientGetVariableInfo",1);
  GTX_TRACE(1, ("(%p)", var_info));
  if (_gtx_start_packet("CVARINFO")) goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SVARINFO")) goto label_end;

  error = GTX_ERROR_NETWORK;
  s[0] = unit_factor;
  if(!_gtx_read_int(_gtx_server_socket, (int*)&var_info->type) ||
     !_gtx_read_int(_gtx_server_socket, &var_info->bit_length) ||
     !_gtx_read_int(_gtx_server_socket, &var_info->alpha_length) ||
     !_gtx_read_int(_gtx_server_socket, &var_info->implicit) ||
     !_gtx_read_int(_gtx_server_socket, &var_info->i_number) ||
     !_gtx_read_string(_gtx_server_socket, s, 11))
    goto label_end;

  /* Copy unit in the structure according to linked version */
  unit_length = (_gtx_client_linked_version < 410)? 6: 11;
  (void)strncpy(var_info->unit, unit_factor, unit_length);
  var_info->unit[unit_length-1] = '\0';

  /* Old servers send additional variable comment, ignore it... */
  /* We removed Comment in VarInfo when we added specific functions */
  if (!_gtx_is_supported("CCOMGET",0))
  {
    char comment[500];
    s[0] = comment;
    if (!_gtx_read_string(_gtx_server_socket, s, 500)) goto label_end;
  }

  /* Only version > 410 of protocol includes factor... */
  if (!SERVER_4_1)
  {
    (void)strcpy(unit_symbol, var_info->unit);
    var_info->length_var =
      (GTXClientUnitFactorFromSymbol(unit_symbol) != 0.);
  }
  else
  {
    s[0] = unit_symbol;
    if (!_gtx_read_string(_gtx_server_socket, s, 11) ||
        !_gtx_read_int(_gtx_server_socket, &var_info->length_var))
      goto label_end;
  }

  /* but only clients linked with gtxclient 410 can read it */
  if (_gtx_client_linked_version >= 410)
    (void)strcpy(var_info->unit_symbol, unit_symbol);

  error = GTX_ERROR_NONE;

label_end:
  if (error)
  {
    var_info->type = GTX_VAR_TYPE_INVALID;
    _gtx_cleanup_socket();
  }
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
