/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_memory.c 11482 2008-01-04 20:37:41Z foucher $";

/*!
******************************************************************************
\brief Frees a pointer returned by a previous GTXClient function call

This function frees the memory allocated by a previous call to a GTXClient
function which returned a pointer (except for string arrays).

\return NULL value

\param pointer pointer to be freed

\remarks: this function is meant to only free memory allocated by a GTXClient
function. It simply calls free on the pointer but avoid inter-DLL memory
problems under Windows. For string arrays, use \sa GTXClientFreeStringArray.
*****************************************************************************/
void *GTXClientFreePointer(void *pointer)
{
  GTX_TRACE_FUNC_START("GTXClientFreePointer",1);
  GTX_TRACE(1, ("(%p)", pointer));
  if (pointer)
    free(pointer);
  GTX_TRACE_FUNC_END("(nil)",NULL);
  return(NULL);
}

/*!
******************************************************************************
\brief Frees a string array returned by a previous GTXClient function call

This function frees the memory allocated by a previous call to a GTXClient
function which returned an array of string.

\return NULL value

\param narray number of items in the array
\param array string array to be freed

\remarks: this function is meant to only free memory allocated by a GTXClient
function. It is equivalent to call GTXClientFreePointer on each array item and
on the array itself.
*****************************************************************************/
char **GTXClientFreeStringArray(gtx_long narray,
                                char **array)
{
  int i;

  GTX_TRACE_FUNC_START("GTXClientFreeStringArray",1);
  GTX_TRACE(1, ("(%d,%p)", narray, array));
  if (array)
  {
    for (i = 0; i < narray; i++)
      if (array[i])
        free(array[i]);
    free(array);
  }
  GTX_TRACE_FUNC_END("(nil)", NULL);
  return(NULL);
}
