/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_modif_grid_file.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Modify the origin of the current file (must be a grid)

This function modify the origin of the current file (must be a grid)
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param x0 X origin of the grid
\param y0 Y origin of the grid
\param z0 Z origin of the grid (unused if 2D)

\par Remarks:
The new origin must be given in the current unit (\ref GTXClientSetUnit) if
unit_mode = 0 (\ref GTXClientSetUnitMode). Elsewhere, you must enter the new
origin according to each coordinate variable unit.
*****************************************************************************/
int GTXClientGridModifyOrigin(double x0, double y0, double z0)
{
  GTXErrorCode error;
  char answer[10];

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientGridModifyOrigin",1);
  GTX_TRACE(1, ("(%g,%g,%g)", x0,y0,z0));
  if( _gtx_start_packet("GRIDMODO") ) goto label_end;

  if( !_gtx_write_double(_gtx_server_socket, &x0) ||
      !_gtx_write_double(_gtx_server_socket, &y0) ||
      !_gtx_write_double(_gtx_server_socket, &z0) ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if( error ) _gtx_cleanup_socket();

  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Modify the mesh of the current file (must be a grid)
 
This function modify the mesh of the current file (must be a grid)
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param dx X size of one cell of the grid
\param dy Y size of one cell of the grid
\param dz Z size of one cell of the grid (unused if 2D)

\par Remarks:
The new mesh must be given in the current unit (\ref GTXClientSetUnit) if
unit_mode = 0 (\ref GTXClientSetUnitMode). Elsewhere, you must enter the new
mesh according to each coordinate variable unit.
*****************************************************************************/
int GTXClientGridModifyMesh(double dx, double dy, double dz)
{
  GTXErrorCode error;
  char answer[10];
 
  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientGridModifyMesh",1);
  GTX_TRACE(1, ("(%g,%g,%g)", dx,dy,dz));
  if( _gtx_start_packet("GRIDMODM") ) goto label_end;
 
  if( !_gtx_write_double(_gtx_server_socket, &dx) ||
      !_gtx_write_double(_gtx_server_socket, &dy) ||
      !_gtx_write_double(_gtx_server_socket, &dz) ) goto label_end;
 
  if( _gtx_send_and_wait(answer) ) goto label_end;
 
  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;
 
  error = GTX_ERROR_NONE;
 
label_end:
  if( error ) _gtx_cleanup_socket();
 
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Modify the rotation of the current file (must be a grid)
 
This function modify the rotation of the current file (must be a grid)
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param az rotation around Z axis
\param ay rotation around the Y'-axis (new Y axis in the system after the first rotation) (unused in 2D)
\param ax rotation around the X"-axis (new X axis in the systemd after the two first rotations) (unused in 2D)
*****************************************************************************/
int GTXClientGridModifyRotation(double az, double ay, double ax)
{
  GTXErrorCode error;
  char answer[10];
 
  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientGridModifyRotation",1);
  GTX_TRACE(1, ("(%g,%g,%g)", az,ay,ax));
  if( _gtx_start_packet("GRIDMODR") ) goto label_end;
 
  if( !_gtx_write_double(_gtx_server_socket, &az) ||
      !_gtx_write_double(_gtx_server_socket, &ay) ||
      !_gtx_write_double(_gtx_server_socket, &ax) ) goto label_end;
 
  if( _gtx_send_and_wait(answer) ) goto label_end;
 
  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;
 
  error = GTX_ERROR_NONE;
 
label_end:
  if( error ) _gtx_cleanup_socket();
 
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

