/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_new_char_var.c 26470 2016-09-05 09:17:50Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Create a new character variable in the current file

This function create a new character variable in the current file.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param name Name of the variable to be created
\param max_length Maximum length of string per sample (without \\0)
*****************************************************************************/
int GTXClientNewCharVariable(const char *name, int max_length)
{
  GTXErrorCode error;
  const char *s[1];
  char answer[10];

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientNewCharVariable",1);
  GTX_TRACE(1, ("(%s,%d)", name,max_length));
  if (max_length <= 0)
  {
    _gtx_error("GTXClientNewCharVariable(): "
      "cannot create alphanumerical variable with negative or null");
    goto label_end;
  }
     
  if( _gtx_start_packet("CVARCNEW") ) goto label_end;

  s[0] = name;
  if( !_gtx_write_string(_gtx_server_socket, s, 10000) ||
      !_gtx_write_int(_gtx_server_socket, &max_length) )
    goto label_end;
  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if( error ) _gtx_cleanup_socket();

  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Set the current variable as the Line Name variable

This function sets the current variable as the line name of the file in which
it appears. The file must be a Points file linked to Lines file and the
variable must be alphanumerical.

\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
*****************************************************************************/
int GTXClientSetVariableAsLineName(void)
{
  GTXErrorCode error;
  char answer[10];

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientSetVariableAsLineName",0);

  /* Silently ignore old versions */
  if (!_gtx_is_supported("CVARLNAME", 0))
  {
    error = GTX_ERROR_NONE;
    goto label_end;
  }

  if (_gtx_start_packet("CVARLNAME")) goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if(_gtx_check_answer(answer, "SDONE")) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();

  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
