/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_new_float_var.c 11781 2008-02-19 10:21:48Z marin $";

#include <string.h> /* strcpy() on solaris */


/*!
******************************************************************************
\brief Create a new double (or macro) variable in the current file

This function creates a new double variable (also known as numerical variable)
in the current file
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param name Name of the variable to be created (will be a macro variable if
            name ends with [xxxxx])
\param bit_length Number of bits per sample, authorized values are
                  1, 2, 4, 8, 16, 32 and 64
\param format_type Ouput printing format
\param format_length Ouput printing length (3 to 19)
\param format_digits Number of digits (0 to 9)
\param format_unit Unit string, use NULL or empty string for length variable

\par Remarks:
If you use NULL as the unit string, the variable will be a length variable
with the current default unit symbol and factor (\ref GTXClientSetUnit).
If the format_unit is part of the known length units list, the variable will
be a length one with the specified unit and corresponding factor, elsewhere
a float variable will be created.
If you need to have a length variable with different unit symbol and factor,
use \ref GTXClientSetVariableUnit.
To create a selection, use 1 for the bit_length.
To create a macro variable, use a name ending with [xxxxx].
To create a macro-selection, use a name ending with [xxxxx] and a bitlength of 1.
*****************************************************************************/
int GTXClientNewDoubleVariable(const char *name,
                               int bit_length,
                               GTX_FORMAT_TYPE format_type,
                               int format_length,
                               int format_digits,
                               const char *format_unit)
{
  int nunits, macro_mode;
  GTXErrorCode error;
  const char *s[1];
  char answer[10];
  char unit_str[11];

  error = GTX_ERROR_PARAMETER;
  GTX_TRACE_FUNC_START("GTXClientNewDoubleVariable",1);
  GTX_TRACE(1, ("(%s,%d,%d,%d,%d,%s)",
                name,bit_length,format_type,format_length,
                format_digits,format_unit));
  if (format_type < GTX_FORMAT_TYPE_DECIMAL ||
      format_type >= GTX_FORMAT_TYPE_INVALID)
  {
    _gtx_error
      ("GTXClientNewDoubleVariable(): wrong output format type.");
    goto label_end;
  }

  macro_mode = (strlen(name) > 7 && !strcmp(&name[strlen(name)-7], "[xxxxx]"));

  if (!_gtx_is_supported("CVARMNEW", 1))
    goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!macro_mode && _gtx_start_packet("CVARFNEW")) goto label_end;
  else if (macro_mode && _gtx_start_packet("CVARMNEW")) goto label_end;

  nunits = 0;
  if (format_unit != NULL) nunits++;

  s[0] = name;
  if (!_gtx_write_string(_gtx_server_socket, s, 10000)) goto label_end;

  if (!_gtx_write_int(_gtx_server_socket, &bit_length) ||
      !_gtx_write_int(_gtx_server_socket, (int*)&format_type) ||
      !_gtx_write_int(_gtx_server_socket, &format_length) ||
      !_gtx_write_int(_gtx_server_socket, &format_digits)) goto label_end;

  /* For server version < 410, change unit and write it */
  if (!SERVER_4_1)
  {
    if (format_unit == NULL)
      (void)strcpy(unit_str, "");
    else
    {
      (void)strncpy(unit_str, format_unit, 5);
      unit_str[5] = '\0';
    }
    s[0] = unit_str;
    if (!_gtx_write_string(_gtx_server_socket, s, 6)) goto label_end;
  }
  /* server >= 410: Write unit only if needed */
  else
  {
    nunits = (format_unit == NULL)? 0: 1;
    if (!_gtx_write_int(_gtx_server_socket, &nunits)) goto label_end;

    if (nunits)
    {
      s[0] = unit_str;
      unit_str[10] = '\0';
      (void)strncpy(unit_str, format_unit, 10);
      if (!_gtx_write_string(_gtx_server_socket, s, 11)) goto label_end;
    }
  }

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SDONE")) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
