/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_new_grid_file.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Create a new grid file in the current directory

This function create a new grid file in the current directory.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param name Name of the grid file to be created
\param dimension 2 for a 2D grid, 3 for a 3D grid
\param X0 X origin of the grid
\param Y0 Y origin of the grid
\param Z0 Z origin of the grid (unused if 2D)
\param DX X size of one cell of the grid
\param DY Y size of one cell of the grid
\param DZ Z size of one cell of the grid (unused if 2D)
\param NX X nodes number
\param NY Y nodes number
\param NZ Z nodes number (unused if 2D)

\par Remarks:
The file will be created using the current unit (\ref GTXClientSetUnit) or
the creation units (\ref GTXClientSetCreationUnits) if unit_mode is 1
(\ref GTXClientSetUnitMode).
The grid origin and mesh must be given in the current unit if unit_mode = 0
or according to the corresponding creation unit if unit_mode = 1.
*****************************************************************************/
int GTXClientNewGridFile(const char *name, int dimension,
                         double X0, double Y0, double Z0,
                         double DX, double DY, double DZ,
                         int NX, int NY, int NZ)
{
  GTXErrorCode error;
  const char *s[1];
  char answer[10];

  error = GTX_ERROR_PARAMETER;
  GTX_TRACE_FUNC_START("GTXClientNewGridFile",1);
  GTX_TRACE(1, ("%s,%d,%g,%g,%g,%g,%g,%g,%d,%d,%d)",
                name,dimension,X0,Y0,Z0,DX,DY,DZ,NX,NY,NZ));
  if( dimension < 2 || dimension > 3 )
  {
    _gtx_error("GTXClientNewGridFile(): invalid dimension.");
    goto label_end;
  }

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CGFILENEW") ) goto label_end;

  s[0] = name;
  if( !_gtx_write_string(_gtx_server_socket, s, 10000) ||
      !_gtx_write_int(_gtx_server_socket, &dimension) ) goto label_end;

  if( !_gtx_write_double(_gtx_server_socket, &X0) ||
      !_gtx_write_double(_gtx_server_socket, &DX) ||
      !_gtx_write_int(_gtx_server_socket, &NX) ||
      !_gtx_write_double(_gtx_server_socket, &Y0) ||
      !_gtx_write_double(_gtx_server_socket, &DY) ||
      !_gtx_write_int(_gtx_server_socket, &NY) ) goto label_end;

  if( dimension == 3 &&
      (!_gtx_write_double(_gtx_server_socket, &Z0) ||
       !_gtx_write_double(_gtx_server_socket, &DZ) ||
       !_gtx_write_int(_gtx_server_socket, &NZ)) ) goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
