/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_new_points_file.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Create a new points file in the current directory

This function create a new points file in the current directory.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param name Name of the file to be created
\param nsample Number of samples to be created in this file
\param x Array of X coordinate of each sample
\param y Array of Y coordinate of each sample
\param z Array of Z coordinate of each sample (or NULL)

\par Remarks:
To create a 2D file, set z to NULL.

The file will be created using the current unit (\ref GTXClientSetUnit) or
the creation units (\ref GTXClientSetCreationUnits) if unit_mode
is 1 (\ref GTXClientSetUnitMode).

The X,Y and Z values must be given in the current unit if unit_mode = 0
or according to the corresponding creation unit if unit_mode = 1.
*****************************************************************************/
int GTXClientNewPointsFile(const char *name, gtx_long nsample,
                           const double *x, const double *y, const double *z)
{
  int dimension;
  GTXErrorCode error;
  const char *s[1];
  char answer[10];

  GTX_TRACE_FUNC_START("GTXClientNewPointsFile",1);
  GTX_TRACE(1, ("(%s,%"GTXLONG_FORMAT",%p,%p,%p)",name,nsample,x,y,z));
  dimension = (z == NULL) ? 2 : 3;

  error = GTX_ERROR_PARAMETER;
  if( x == NULL || y == NULL )
  {
    _gtx_error("GTXClientNewPointsFile(): X and Y coordinates arrays cannot be NULL.");
    goto label_end;
  }

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CPFILENEW") ) goto label_end;

  s[0] = name;
  if (!_gtx_write_string(_gtx_server_socket, s, 10000) ||
      !_gtx_write_long(_gtx_server_socket, &nsample) ||
      !_gtx_write_int(_gtx_server_socket, &dimension)) goto label_end;

  if (!_gtx_rw_vector(_gtx_server_socket, (char*)x, nsample,
                      sizeof(double), (_gtx_proc_rw_t)_gtx_write_double) ||
      !_gtx_rw_vector(_gtx_server_socket, (char*)y, nsample,
                      sizeof(double), (_gtx_proc_rw_t)_gtx_write_double))
    goto label_end;

  if (z != NULL &&
      !_gtx_rw_vector(_gtx_server_socket, (char*)z, nsample,
                      sizeof(double), (_gtx_proc_rw_t)_gtx_write_double))
    goto label_end;

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Append samples to the current Points File

This function appends samples to the current Points File
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param nsample Number of samples to be appended in this file
\param x Array of X coordinate of each sample
\param y Array of Y coordinate of each sample
\param z Array of Z coordinate of each sample (or NULL)

\par Remarks:
If current file is a 2D file, set z to NULL.

The X,Y and Z values must be given in the current unit if unit_mode = 0
or according to the corresponding units if unit_mode = 1.

Creating a Points File by appending samples 1 by 1 is not optimum at all.
If you know the number of samples from the beginning, you should directly
create the file with the right number of points.
*****************************************************************************/
int GTXClientPointsFileAppend(gtx_long nsample,
                              const double *x, const double *y, const double *z)
{
  int dimension;
  GTXErrorCode error;
  char answer[10];

  GTX_TRACE_FUNC_START("GTXClientPointsFileAppend",1);
  GTX_TRACE(1, ("(%"GTXLONG_FORMAT",%p,%p,%p)",nsample,x,y,z));
  dimension = (z == NULL)? 2: 3;

  error = GTX_ERROR_PARAMETER;
  if (x == NULL || y == NULL)
  {
    _gtx_error("GTXClientPointsFileAppend(): X and Y coordinates arrays cannot be NULL.");
    goto label_end;
  }

  error = GTX_ERROR_SERVER;
  if (!_gtx_is_supported("CPFILEAPP", 1))
    goto label_end;

  error = GTX_ERROR_NETWORK;
  if (_gtx_start_packet("CPFILEAPP")) goto label_end;

  if (!_gtx_write_long(_gtx_server_socket, &nsample) ||
      !_gtx_write_int(_gtx_server_socket, &dimension)) goto label_end;

  if (!_gtx_rw_vector(_gtx_server_socket, (char*)x, nsample,
                      sizeof(double), (_gtx_proc_rw_t)_gtx_write_double) ||
      !_gtx_rw_vector(_gtx_server_socket, (char*)y, nsample,
                      sizeof(double), (_gtx_proc_rw_t)_gtx_write_double))
    goto label_end;

  if (z != NULL &&
      !_gtx_rw_vector(_gtx_server_socket, (char*)z, nsample,
                      sizeof(double), (_gtx_proc_rw_t)_gtx_write_double))
    goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SDONE")) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
