/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_new_polygons_file.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Create a new polygon file in the current directory

This function creates a new polygons file in the current directory.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param filename File name of the polygons file
\param polygon_system Polygon system to be created


\par Remarks:
The file will be created using the current unit (\ref GTXClientSetUnit) or
the creation units (\ref GTXClientSetCreationUnits) if unit_mode is 1
(\ref GTXClientSetUnitMode).

The X,Y and Z values must be given in the current unit if unit_mode = 0
or according to the corresponding creation unit if unit_mode = 1.
*****************************************************************************/
int GTXClientNewPolygonsFile(const char *filename,
                             const GTXPolygonSystem *polygon_system)
{
  const char *s1[1];
  const char *s2[1];
  gtx_long i;
  int j;
  GTXErrorCode error;
  char answer[10];
  GTXPolygon *poly;

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientNewPolygonsFile",1);
  GTX_TRACE(1, ("(%s,%p)",filename, polygon_system));
  if( _gtx_start_packet("CPOLYNEW") ) goto label_end;

  s1[0] = filename;
  if( !_gtx_write_string(_gtx_server_socket, s1, 10000) )
    goto label_end;

  if( !_gtx_write_bool(_gtx_server_socket, &polygon_system->polygons_2d) ||
      !_gtx_write_double(_gtx_server_socket, &polygon_system->ext_min[0]) ||
      !_gtx_write_double(_gtx_server_socket, &polygon_system->ext_min[1]) ||
      !_gtx_write_double(_gtx_server_socket, &polygon_system->ext_min[2]) ||
      !_gtx_write_double(_gtx_server_socket, &polygon_system->ext_max[0]) ||
      !_gtx_write_double(_gtx_server_socket, &polygon_system->ext_max[1]) ||
      !_gtx_write_double(_gtx_server_socket, &polygon_system->ext_max[2]) ||
      !_gtx_write_long(_gtx_server_socket, &polygon_system->n_polygons) )
    goto label_end;
 
  for(i=0; i<polygon_system->n_polygons; i++)
  {
    poly = &polygon_system->polygons[i];
    s1[0] = poly->name;
    s2[0] = poly->group_name;
    if( !_gtx_write_string(_gtx_server_socket, s1, 16) ||
        !_gtx_write_string(_gtx_server_socket, s2, 16) ||
        !_gtx_write_double(_gtx_server_socket, &poly->z_min) ||
        !_gtx_write_double(_gtx_server_socket, &poly->z_max) ||
        !_gtx_write_int(_gtx_server_socket, &poly->n_vertices) )
      goto label_end;
 
    for(j=0; j<poly->n_vertices*2; j++)
      if( !_gtx_write_double(_gtx_server_socket, &poly->vertices[j]) )
        goto label_end;
  } /* end of loop on polygons */

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
