/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_new_study.c 20888 2012-08-17 08:37:14Z foucher $";

/*!
******************************************************************************
\brief Create a new study in the Isatis file system

This function create a new study in the Isatis file system.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param name Name of the study to be created (logical study name)
\param path Physical study PATH (must be a non existing directory in an existing parent directory)

\remark The physical path correspond to the directory where the study contents
will be stored. This path is only used/needed for Isatis >= 4.1 (because before
that, all studies were stored near to each other).
*****************************************************************************/
int GTXClientNewStudy(const char *name,
                      const char *path)
{
  GTXErrorCode error;
  char answer[10];
  const char *s[1];

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientNewStudy",1);
  GTX_TRACE(1, ("(%s,%s)",name, path));
  if( _gtx_start_packet("CSTUDYNEW") ) goto label_end;

  s[0] = name;
  if( !_gtx_write_string(_gtx_server_socket, s, 10000) ) goto label_end;

  /* Only version >= 410 of protocol includes PATH... */
  if (SERVER_4_1)
  {
    s[0] = path;
    if(!_gtx_write_string(_gtx_server_socket, s, 10000)) goto label_end;
  }

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if( error ) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
