/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_read_char_var.c 25941 2016-04-05 15:10:18Z foucher $";

#include <string.h> /* strcpy() on solaris */

GTXErrorCode st_read_var(gtx_long first, gtx_long last,
                         int compress, char **test_val, gtx_long *nb_val,
                         char ***data)
{
  char answer[10];
  gtx_long i, size;
  GTXErrorCode error;

  *nb_val = 0;
  *test_val = NULL;
  *data = NULL;

  error = GTX_ERROR_NETWORK;
  if( _gtx_start_packet("CREADVARC") ) goto label_end;

  if (_gtx_client_server_version >= 608000 &&
      (!_gtx_write_long(_gtx_server_socket, &first) ||
       !_gtx_write_long(_gtx_server_socket, &last)))
    goto label_end;
  if( !_gtx_write_int(_gtx_server_socket, &compress) ) goto label_end;
  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDATAC") ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if( !_gtx_read_long(_gtx_server_socket, nb_val) ) goto label_end;
  if( !_gtx_read_string(_gtx_server_socket, test_val, 10000) ) goto label_end;

  error = GTX_ERROR_MEMORY;
  size = sizeof(char*) * *nb_val;
  *data = (char**)malloc(size);
  if( *data == NULL ) goto label_end;

  error = GTX_ERROR_NETWORK;
  for (i=0; i<*nb_val; i++) (*data)[i] = NULL;

  if (!_gtx_rw_vector(_gtx_server_socket, (char*)*data, *nb_val,
                      sizeof(char*), (_gtx_proc_rw_t)_gtx_read_string))
    goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error)
  {
    *data = GTXClientFreeStringArray(*nb_val, *data);
    *test_val = GTXClientFreePointer(*test_val);
    *nb_val = 0;
  }
  return error;
}

/*!
******************************************************************************
\brief Read samples from the current variable

This function read all samples from the current variable. The variable
must be an alphanumerical variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param compress Samples masked by the current selection are transformed
                into test values if 0, or do not appear in the output array
                if this flag is set to 1
\retval test_val Value used for undefined samples
\retval nb_val Number of kept samples
\retval data Array of character variable samples

\par Remarks:
test_val must be freed using:
\code
test_val = GTXClientFreePointer(test_val);
\endcode
data must be freed using:
\code
*data = GTXClientFreeStringArray(*nb_val, *data);
\endcode
*****************************************************************************/
int GTXClientReadCharVariable(int compress, char **test_val, gtx_long *nb_val,
                              char ***data)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientReadCharVariable",1);
  GTX_TRACE(1, ("(%d,%p,%p,%p)",compress,test_val,nb_val,data));
  error = st_read_var(-1, -1, compress, test_val, nb_val, data);
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Read continuous samples from the current variable

This function read contiguous samples from the current variable. The variable
must be an alphanumerical variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param first Sample Number of the first item to read (from 1 to nsample)
\param last  Sample Number of the last item to read (from 1 to nsample)
\param compress Samples masked by the current selection are transformed
                into test values if 0, or do not appear in the output array
                if this flag is set to 1
\retval test_val Value used for undefined samples
\retval nb_val Number of kept samples
\retval data Array of character variable samples

\par Remarks:
test_val must be freed using:
\code
test_val = GTXClientFreePointer(test_val);
\endcode
data must be freed using:
\code
*data = GTXClientFreeStringArray(*nb_val, *data);
\endcode
*****************************************************************************/
int GTXClientReadCharVariableSub(gtx_long first, gtx_long last,
                                 int compress, char **test_val,
                                 gtx_long *nb_val, char ***data)
{
  GTXErrorCode error = GTX_ERROR_NETWORK;

  GTX_TRACE_FUNC_START("GTXClientReadCharVariable",1);
  GTX_TRACE(1, ("(%"GTXLONG_FORMAT",%"GTXLONG_FORMAT",%d,%p,%p,%p)",
                first,last,compress,test_val,nb_val,data));

  if (_gtx_client_server_version < 608000)
  {
    _gtx_error("GTXClientReadCharVariableSub() "
               "does not work with a server version lower than 6.0.8");
    _gtx_error("Please upgrade your server "
               "(http://www.geovariances.fr)");
  }
  else
    error = st_read_var(first, last, compress, test_val, nb_val, data);
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}


/*!
******************************************************************************
\brief Read a line from the current variable

This function read a line from the current variable.
The variable must be an numerical variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param  line_index The index of the line [1..nline]
\retval test_val   Value used for undefined samples
\retval nsample    Number samples
\retval data       Array of variable samples

\par Remarks:
test_val must be freed using:
\code
test_val = GTXClientFreePointer(test_val);
\endcode
data must be freed using:
\code
*data = GTXClientFreeStringArray(*nsample, *data);
\endcode

Warning: This functions needs a server version >= 16.01beta
*****************************************************************************/
int GTXClientReadLineCharVariable(int line_index, char **test_val, int *nsample, char ***data)
{
  int i;
  size_t size;
  GTXErrorCode error;
  char answer[10];

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientReadLineDoubleVariable",1);
  GTX_TRACE(1, ("(%d,%p,%p,%p)", line_index, test_val, nsample, data));

  *data = NULL;
  *test_val = NULL;
  *nsample = 0;

  if (_gtx_start_packet("CREADLINC")) goto label_end;
  if (!_gtx_write_int(_gtx_server_socket, &line_index))
    goto label_end;
  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SDATAC")) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_read_int(_gtx_server_socket, nsample)) goto label_end;

  if (!_gtx_read_string(_gtx_server_socket, test_val, 1000)) goto label_end;

  error = GTX_ERROR_MEMORY;
  size = sizeof(char*) * *nsample;
  *data = (char**)malloc(size);
  if( *data == NULL ) goto label_end;

  error = GTX_ERROR_NETWORK;
  for (i = 0; i < *nsample; i++) (*data)[i] = NULL;

  if (!_gtx_rw_vector(_gtx_server_socket, (char*)*data, *nsample,
                      sizeof(char*), (_gtx_proc_rw_t)_gtx_read_string))
    goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error)
  {
    *data = GTXClientFreeStringArray(*nsample, *data);
    *test_val = GTXClientFreePointer(*test_val);
    *nsample = 0;
    _gtx_cleanup_socket();
  }
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return error;
}
