/*****************************************************************************
 
            Copyright (c)2009 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_read_float_var.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

static GTXErrorCode st_read_sel(gtx_long first, gtx_long last,
                                gtx_long *nb_val, unsigned char **data)
{
  GTXErrorCode error;
  char answer[10];
  
  *nb_val = 0;
  *data = NULL;

  error = GTX_ERROR_SERVER;
  if (!_gtx_is_supported("CREADVARS", 1))
    goto label_end;

  error = GTX_ERROR_NETWORK;
  if (_gtx_start_packet("CREADVARS")) goto label_end;

  if (!_gtx_write_long(_gtx_server_socket, &first)) goto label_end;
  if (!_gtx_write_long(_gtx_server_socket, &last)) goto label_end;
  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SDATAS")) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_read_long(_gtx_server_socket, nb_val)) goto label_end;

  error = GTX_ERROR_MEMORY;
  *data = (unsigned char*)malloc(sizeof(unsigned char) * *nb_val);
  if (*data == NULL) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_read_bytes(_gtx_server_socket, *data, *nb_val))
    goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error)
  {
    *data = GTXClientFreePointer(*data);
    *nb_val = 0;
    _gtx_cleanup_socket();
  }
  return error;
}

/*!
******************************************************************************
\brief Read selection from the current variable

This function read all selection from the current variable. The variable
must be an numerical variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval nb_val Number of kept selection
\retval data Array of variable selection

\par Remarks:
data must be freed using:
\code
data = GTXClientFreePointer(data);
\endcode

If the variable is a length one, data is returned in the current unit
(\ref GTXClientSetUnit) if unit_mode is 0 (\ref GTXClientSetUnitMode).
If the variable is a length one and unit_mode is 1, the variable unit is
used instead.

Warning: This functions needs a server version >= 7.0.8beta or 8.00
*****************************************************************************/
int GTXClientReadSelectionVariable(gtx_long *nb_val, unsigned char **data)
{
  GTXErrorCode error;
  GTX_TRACE_FUNC_START("GTXClientReadSelectionVariable",1);
  GTX_TRACE(1, ("(%p,%p)",nb_val,data));
  error = st_read_sel(-1, -1, nb_val, data);
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Read a subpart of the selection from the current variable

This function read a subpart of the selection from the current variable.
The variable must be an numerical variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param first Selection Number of the first item to read (from 1 to nselection)
\param last  Selection Number of the last item to read (from 1 to nselection)
\retval nb_val Number of kept selection (obviously if not using a selection,
               this will be last-first+1)
\retval data Array of variable selection

\par Remarks:
data must be freed using:
\code
data = GTXClientFreePointer(data);
\endcode

Warning: This functions needs a server version >= 7.0.8beta or 8.00
*****************************************************************************/
int GTXClientReadSelectionVariableSub(gtx_long first, gtx_long last,
                                      gtx_long *nb_val, unsigned char **data)
{
  GTXErrorCode error = GTX_ERROR_NETWORK;

  GTX_TRACE_FUNC_START("GTXClientReadSelectionVariableSub",1);
  GTX_TRACE(1, ("(%"GTXLONG_FORMAT",%"GTXLONG_FORMAT",%d,%d,%p,%p)",
                first,last,nb_val,data));
  error = st_read_sel(first, last, nb_val, data);
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
