/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_set_indice.c 11759 2008-02-15 09:06:53Z marin $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Set the current indice for the current macro variable

Set the current indice for the current macro variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param indice Macro indice to set

\par Remarks:
Current variable should have been set before.
*****************************************************************************/
int GTXClientSetIndice(const int indice)
{
  GTXErrorCode error;
  char answer[10];

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientSetIndice",1);
  GTX_TRACE(1, ("(%d)",indice));
  if( _gtx_start_packet("CINDSET") ) goto label_end;

  if( !_gtx_write_int(_gtx_server_socket, &indice) ) goto label_end;
  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Set the current alpha indice for the current macro variable

Set the current alpha indice for the current macro variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param alphaindice Macro alpha indice to set

\par Remarks:
Current variable should have been set before.
*****************************************************************************/
int GTXClientSetAlphaIndice(const char *alphaindice)
{
  GTXErrorCode error;
  char answer[10];
  const char *s[1];
  int indice = -1;
  int i,nb_indices,*indices;
  char **alpha_indices = NULL;



  s[0] = alphaindice;
  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientSetAlphaIndice",1);
  GTX_TRACE(1, ("(%s)",alphaindice));

  if (_gtx_is_supported("CINDASET", 0))
  {
    if( _gtx_start_packet("CINDASET") ) goto label_end;
    
    if( !_gtx_write_string(_gtx_server_socket, s, 10000) ) goto label_end;
    if( _gtx_send_and_wait(answer) ) goto label_end;
    
    error = GTX_ERROR_SERVER;
    if( _gtx_check_answer(answer, "SDONE") ) goto label_end;
  }
  else
  {
    error = GTX_ERROR_PARAMETER;
    if (GTXClientGetMacroIndicesWithAlpha(&nb_indices, &indices, &alpha_indices)) goto label_end;
    if (!alpha_indices)
    {
      _gtx_error("No alpha index available for this variable");
      goto label_end;
    }
    for (i = 0; i < nb_indices; i++)
    {
      if (!strcmp(alpha_indices[i], alphaindice))
        indice = indices[i];
    }
    if (GTXClientSetIndice(indice))
    {
      error = GTXClientGetLastError();
      goto label_end;
    }
  }
  error = GTX_ERROR_NONE;
label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
