/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_supported.c 22380 2013-05-02 10:23:49Z support $";

/****************************************************************************
**
** FUNCTION: _gtx_is_supported
**
** PURPOSE:  Is a given Request Supported or not
**
** RETURNS:  1 if supported, 0 elsewhere
**
** IN_ARGS:  request       : given request
** IN_ARGS:  generate_error: 1 to output an error message, 0 elsewhere
**
*****************************************************************************/
int _gtx_is_supported(char *request,
                      int generate_error)
{
  int i, ok, modif1, modif2;

  /* Recent servers: use supported request table */
  ok = 0;
  if (_gtx_client_server_version > 400000)
  {
    for (i = 0; i < _gtx_client_n_supported_requests && !ok; i++)
      if (!strcmp(_gtx_client_supported_requests[i], request))
        ok = 1;
  }
  else
  {
    /* Older servers: compare versions for some known requests */
    /* modif1 (4.0.7beta (tagged 4.0.7), 4.1.1) */
    modif1 = (_gtx_client_server_version >= 407 &&
              _gtx_client_server_version != 410);
    /* modif2 (4.0.7beta (tagged 4.0.8), 4.1.2) */
    modif2 = (_gtx_client_server_version >= 408 &&
              (_gtx_client_server_version < 410 ||
               _gtx_client_server_version >= 412));
    if (!strcmp(request, "CVDATEXIS"))
      ok = modif1;
    else if (!strcmp(request, "CFILETLST") || !strcmp(request, "CVARTLST"))
      ok = modif2;
  }
  if (!ok && generate_error)
  {
    _gtx_error("Server Request not recognized (%s)", request);
    _gtx_error("Please upgrade your Isatis version or GTXserver if you don't have Isatis"
               "(http://www.geovariances.fr)");
  }
  return(ok);
}

/*!
******************************************************************************
\brief Is Server supporting a given feature ?

This function checks if the GTXserver support a given feature and can output an
error message if not. 

\param type feature requested
\param generate_error: output an error message using the error function

\return feature_supported:
  \arg 0 if the feature is NOT supported
  \arg 1 if the feature IS supported
*****************************************************************************/
int GTXClientServerHasFeature(GTXFeatureType type,
			      int generate_error)
{
  char enc_type[10];
  switch (type)
  {
    case GTX_FEATURE_PALETTES:
      return _gtx_is_supported("CPALLST", generate_error);
    case GTX_FEATURE_COLOR_SCALES:
      return _gtx_is_supported("CSCALST", generate_error);
  }
  (void)sprintf(enc_type, "CUNK%d", (int)type);
  return _gtx_is_supported(enc_type, generate_error);
}
