/*****************************************************************************
 
            Copyright (c)2009 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_write_fault.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Create a new Write wireframes file in the current directory

This function creates a new wireframes file in the current directory.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param filename Name of the Wireframes File that has to be created
\param wireframe_system Wireframe system to be stored in the current file
*****************************************************************************/
int GTXClientNewWireframesFile(const char *filename,
                               const GTXWireframeSystem *wireframe_system)
{
  const char *s[1];
  int i, j;
  GTXErrorCode error;
  char answer[10];
  GTXWireframe *wireframe;
  GTXWireframeObject *object;

  GTX_TRACE_FUNC_START("GTXClientWriteWireframes",1);
  GTX_TRACE(1, ("(%p)", wireframe_system));

  error = GTX_ERROR_SERVER;
  if (!_gtx_is_supported("CWIRENEW", 1))
    goto label_end;

  error = GTX_ERROR_NETWORK;
  if (_gtx_start_packet("CWIRENEW")) goto label_end;

  s[0] = filename;
  if (!_gtx_write_string(_gtx_server_socket, s, 10000) ||
      !_gtx_write_int(_gtx_server_socket, &wireframe_system->n_wireframes) )
    goto label_end;

  wireframe = wireframe_system->wireframes;
  for (i = 0; i < wireframe_system->n_wireframes; i++, wireframe++)
  {
    s[0] = wireframe->name;
    if (!_gtx_write_string(_gtx_server_socket, s, 50) ||
        !_gtx_write_int(_gtx_server_socket, &wireframe->color[0]) ||
        !_gtx_write_int(_gtx_server_socket, &wireframe->color[1]) ||
        !_gtx_write_int(_gtx_server_socket, &wireframe->color[2]) ||
        !_gtx_write_int(_gtx_server_socket, &wireframe->n_objects) )
      goto label_end;
 
    object = wireframe->objects;
    for (j = 0; j < wireframe->n_objects; j++, object++)
    {
      if (!_gtx_write_int(_gtx_server_socket, &object->n_vertices) ||
          !_gtx_write_int(_gtx_server_socket, &object->n_triangles) ||
          !_gtx_rw_vector(_gtx_server_socket, (char*)object->vertices,
                          object->n_vertices*3,
                          sizeof(double), (_gtx_proc_rw_t)_gtx_write_double) ||
          !_gtx_rw_vector(_gtx_server_socket, (char*)object->triangles,
                          object->n_triangles*3,
                          sizeof(int), (_gtx_proc_rw_t)_gtx_write_int))
        goto label_end;
    } /* loop on objects */
  } /* end of loop on wireframes */

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
