/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_write_fault.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Write fault system to the current file

This function store a fault system in the current file.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param fault_system Fault system to be stored in the current file
*****************************************************************************/
int GTXClientWriteFaults(const GTXFaultSystem *fault_system)
{
  const char *s[1];
  int i, j;
  GTXErrorCode error;
  char answer[10];
  GTXFault *fault;
  GTXFaultSegment *segment;

  error = GTX_ERROR_NETWORK;
  GTX_TRACE_FUNC_START("GTXClientWriteFaults",1);
  GTX_TRACE(1, ("(%p)", fault_system));
  if( _gtx_start_packet("CWRITFAUL") ) goto label_end;
  if( !_gtx_write_bool(_gtx_server_socket, &fault_system->faults_2d) ||
      !_gtx_write_bool(_gtx_server_socket, &fault_system->aux_var_used) ||
      !_gtx_write_double(_gtx_server_socket, &fault_system->aux_var_test) ||
      !_gtx_write_int(_gtx_server_socket, &fault_system->n_faults) )
    goto label_end;

  fault = fault_system->faults;
  for(i=0; i<fault_system->n_faults; i++, fault++)
  {
    s[0] = fault->name;
    if( !_gtx_write_string(_gtx_server_socket, s, 8) ||
        !_gtx_write_bool(_gtx_server_socket, &fault->polygon) ||
        !_gtx_write_int(_gtx_server_socket, &fault->n_segments) )
      goto label_end;
 
    segment = fault->segments;
    for(j=0; j<fault->n_segments; j++, segment++)
      if( !_gtx_write_double(_gtx_server_socket, &segment->X1) ||
          !_gtx_write_double(_gtx_server_socket, &segment->Y1) ||
          !_gtx_write_double(_gtx_server_socket, &segment->Z1) ||
          !_gtx_write_double(_gtx_server_socket, &segment->X2) ||
          !_gtx_write_double(_gtx_server_socket, &segment->Y2) ||
          !_gtx_write_double(_gtx_server_socket, &segment->Z2) ||
          !_gtx_write_double(_gtx_server_socket, &segment->X3) ||
          !_gtx_write_double(_gtx_server_socket, &segment->Y3) ||
          !_gtx_write_double(_gtx_server_socket, &segment->Z3) ||
          !_gtx_write_double(_gtx_server_socket, &segment->V1) ||
          !_gtx_write_double(_gtx_server_socket, &segment->V2) ||
          !_gtx_write_double(_gtx_server_socket, &segment->V3) ||
          !_gtx_write_int(_gtx_server_socket, &segment->priority) )
        goto label_end;
  } /* end of loop on faults */

  if( _gtx_send_and_wait(answer) ) goto label_end;

  error = GTX_ERROR_SERVER;
  if( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
