/*****************************************************************************
 
            Copyright (c)2009 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>


static char svnid[] _GTX_UNUSED = "$Id: api_write_float_var.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

static GTXErrorCode st_write_sel_nocheck(const gtx_long first, const gtx_long last,
                                         const gtx_long nb_val, const unsigned char *data)
{
  char answer[10];
  GTXErrorCode error;

  error = GTX_ERROR_NETWORK;
  if (_gtx_start_packet("CWRITVARS")) goto label_end;

  if (!_gtx_write_long(_gtx_server_socket, &first) ||
      !_gtx_write_long(_gtx_server_socket, &last))
    goto label_end;

  if (!_gtx_write_long(_gtx_server_socket, &nb_val))
    goto label_end;

  // _gtx_write_unsigned chars
  if (!_gtx_write_bytes(_gtx_server_socket, data, nb_val))
    goto label_end;
  
  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SDONE")) goto label_end;

  error = GTX_ERROR_NONE;
label_end:
  if (error) _gtx_cleanup_socket();
  return error;
}

static GTXErrorCode st_write_sel(const gtx_long first, const gtx_long last,
                                 const gtx_long nb_val, const unsigned char *data)
{
  int i, j, k, iline, nlines, *scount;
  int lfirst, lnfirst;
  unsigned char *data2;
  GTXErrorCode error;

  data2 = NULL;
  scount = NULL;
  if (!_gtx_is_supported("CWRITVARS", 1))
  {
    error = GTX_ERROR_SERVER;
    goto label_end;
  }

  /* We need to take care of old servers for the line case
  ** because creating core lines adds false sample for each line */
  if (_gtx_client_server_version < 900000)
  {
    GTXFileInfo finfo;
    error = (GTXErrorCode)GTXClientGetFileInfo(&finfo);
    if (error != GTX_ERROR_NONE) goto label_end;
    if (finfo.type == GTX_FILE_TYPE_GRAVITY_LINES &&
        _gtx_is_supported("CLFILECNT", 0))
    {
      error = _gtx_get_line_samples(&nlines, &scount);
      if (error != GTX_ERROR_NONE) goto label_end;

      /* writing the complete file with missing blanks */
      if (((first == -1 && last == -1) ||
           (first == 1 && last == finfo.s_number - finfo.item_number)) &&
          (nb_val == finfo.s_number - finfo.item_number))
      {
        data2 = malloc(sizeof(unsigned char) * finfo.s_number);
        if (data2 == NULL) goto label_end;
        for (iline = j = k = 0; iline < finfo.item_number; iline++)
        {
          data2[k++] = 0;       /* insert empty value */
          for (i = 0; i < scount[iline]-1; i++)
            data2[k++] = data[j++];
        }
        error = st_write_sel_nocheck(1, finfo.s_number, finfo.s_number, data2);
        goto label_end;
      }
      /* writing an only line */
      else if (first != -1)
      {
        error = _gtx_get_line_samples(&nlines, &scount);
        if (error != GTX_ERROR_NONE) goto label_end;

        lfirst = lnfirst = 1;
        for (iline = 0; iline < finfo.item_number; iline++)
        {
          // If we found Sample Numbers corresponding to a complete line with shifted indices
          if (first == lfirst && last == lfirst + scount[iline]-2)
            break;
          lfirst += scount[iline]-1;
          lnfirst += scount[iline];
        }
        if (iline != finfo.item_number)
        {
          // write the defined samples
          error = st_write_sel_nocheck(lnfirst + 1, lnfirst + scount[iline] - 1, scount[iline]-1, data);
          goto label_end;
        }
      }
      /* else we cannot do really more, let the error occur... */
    }
  } /* end of version < 9 management */

  error = st_write_sel_nocheck(first, last, nb_val, data);

label_end:
  if (data2 != NULL) free(data2);
  if (scount != NULL) free(scount);
  if (error) _gtx_cleanup_socket();
  return error;
}

/*!
******************************************************************************
\brief Write selection data (0,1) to the current variable (must be a selection)
 
This function writes data to the current numerical/selection variable
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param nb_val Number of samples in the array (must be set to the number
              of selected samples in the current file)
\param data Array of variable samples (0,1)
 
\par Remarks:
The current selection (which may have been set by GTXClientSetSelection) is
ignored while writing the current variable's (which must also be a selection
variable) contents.
The variable must be have been chosen beforehand by using GTXClientSetVariable.

Warning: This functions needs a server version >= 7.0.8beta or 8.00
*****************************************************************************/
int GTXClientWriteSelectionVariable(const gtx_long nb_val, const unsigned char *data)
{
  GTXErrorCode error;
  GTX_TRACE_FUNC_START("GTXClientWriteSelectionVariable",1);
  GTX_TRACE(1, ("(%"GTXLONG_FORMAT",%p)",nb_val,data));
  error = st_write_sel(-1, -1, nb_val, data);
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}

/*!
******************************************************************************
\brief Write continuous subpart of selection data (0,1) to the current
       variable (must be a selection)
 
This function writes data to the current numerical/selection variable
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param first Sample Number of the first item to write (from 1 to nsample)
\param last  Sample Number of the last item to write (from 1 to nsample)
\param nb_val Number of samples in the array (must be set to the number
              of selected samples in the current file)
\param data Array of variable samples (0,1)
 
\par Remarks:
The current selection (which may have been set by GTXClientSetSelection) is
ignored while writing the current variable's (which must also be a selection
variable) contents.
The variable must be have been chosen beforehand by using GTXClientSetVariable.

Warning: This functions needs a server version >= 7.0.8beta or 8.00
*****************************************************************************/
int GTXClientWriteSelectionVariableSub(const gtx_long first, const gtx_long last,
                                       const gtx_long nb_val, const unsigned char *data)
{
  GTXErrorCode error = GTX_ERROR_NETWORK;

  GTX_TRACE_FUNC_START("GTXClientWriteSelectionVariableSub",1);
  GTX_TRACE(1, ("(%"GTXLONG_FORMAT",%"GTXLONG_FORMAT",%"GTXLONG_FORMAT",%p)",
                first,last,data));
  error = st_write_sel(first, last, nb_val, data);
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
