/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: exec_server.c 9442 2007-01-17 18:03:14Z foucher $";

#ifdef winnt
#include <io.h> /* access on nt */
#include <time.h> /* time on nt */
#else
#include <unistd.h> /* access on solaris */
#endif
#include <sys/types.h>
#include <sys/stat.h>

#include <stdlib.h> /* getenv on solaris */

/***************************************************************************
**
** FUNCTION:    _gtx_exec_server
**
** DESCRIPTION: execute a GTXserver (forking on UNIX, CreateProcess on NT)
**
** RETURNS:     -1 on error (message given), new pid elsewhere
**
** IN_ARGS:     char *server_path: server path (or NULL)
** IN_ARGS:     char *args[]: server arguments (NULL terminated array)
** IN_ARGS:                   must contain argv[0]...
**
** REMARKS:     changes LD_LIBRARY_PATH or LD_LIB_PATH on Unix is a path
** REMARKS:     is given
**
***************************************************************************/
int _gtx_exec_server(char *GTXserver_path,
                     char *args[])
{
  int pid;
  char **arg;
#ifdef winnt
  STARTUPINFO startup_info;
  PROCESS_INFORMATION process_info;
  char cmd_line[1024];
#else
  char *proc_name;
  pid = (int)fork();
#endif

  GTX_TRACE(2,("_gtx_exec_server(%s,%p)",
               GTXserver_path==NULL? "(nil)": GTXserver_path, args));
  if (_gtx_trace_level >= 2)
  {
    GTX_TRACE(2,("Arguments:"));
    for (arg = args; *arg != NULL; arg++)
    {
      GTX_TRACE(2,("  %s", *arg));
    }
  }

#ifdef winnt
  if (GTXserver_path == NULL)
    (void)strcpy(cmd_line, args[0]);
  else
  {
    cmd_line[0] = '\"';
    (void)strcpy(&cmd_line[1], GTXserver_path);
    (void)strcat(cmd_line, "\"");
  }

  arg = args;
  if (*arg != NULL) *arg++;     /* Skip argv[0] */
  for ( ; *arg != NULL; arg++)
  {
    (void)strcat(cmd_line, " ");
    (void)strcat(cmd_line, *arg);
  }
  GTX_TRACE(2,("Creating Process with command line: %s", cmd_line));

  startup_info.cb = sizeof(STARTUPINFO);
  startup_info.lpDesktop = NULL;
  startup_info.lpTitle = NULL;
  startup_info.dwFlags = STARTF_USESHOWWINDOW;
  if (_gtx_client_dbg_mode)
    startup_info.wShowWindow = SW_SHOWDEFAULT;
  else
    startup_info.wShowWindow = SW_MINIMIZE|SW_HIDE;
  startup_info.lpReserved = NULL;
  startup_info.cbReserved2 = 0;
  startup_info.lpReserved2 = NULL;

  if (CreateProcess(NULL, cmd_line, NULL, NULL, FALSE, 0, NULL, NULL,
                    &startup_info, &process_info) == 0)
  {
    LPSTR lpMsgBuf;
    int error = GetLastError();
    FormatMessage(
      FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
      NULL,
      error,
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &lpMsgBuf,
      0,
      NULL);
    _gtx_error("_gtx_exec_server: %s", lpMsgBuf);
    return(-1);
  }
  pid = (int)process_info.dwProcessId;
#else
  switch (pid)
  {
    case -1:
      _gtx_perror("_gtx_exec_server");
      return(-1);

    case 0:                     /* Child Process: Exec Server */
      if (GTXserver_path == NULL)
        proc_name = "GTXserver";
      else
        proc_name = GTXserver_path;
      GTX_TRACE(2,("calling execv(%s,%p)", proc_name,args));
      if (execv(proc_name, args) == -1)
      {
        _gtx_perror("_gtx_exec_server");
        exit(1);
      }
      break;

    default:                    /*  Parent Process */
      break;
  }
#endif
  GTX_TRACE(2,("New Process Id: %d", pid));
  return(pid);
}
