/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.12
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13




#include "GTXByteArray.hpp"
#include "GTXClient.hpp"
#include "GTXDoubleArray.hpp"
#include "GTXError.hpp"
#include "GTXFault.hpp"
#include "GTXFaultInfo.hpp"
#include "GTXFaultSegment.hpp"
#include "GTXFaultSystem.hpp"
#include "GTXFileInfo.hpp"
#include "GTXIntArray.hpp"
#include "GTXPolygon.hpp"
#include "GTXPolygonSystem.hpp"
#include "GTXStringArray.hpp"
#include "GTXVariableFormat.hpp"
#include "GTXVariableInfo.hpp"
#include "GTXVendorData.hpp"
#include "GTXWireframe.hpp"
#include "GTXWireframeObject.hpp"
#include "GTXWireframeSystem.hpp"

#include "GTXCharData.hpp"
#include "GTXDoubleData.hpp"


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXByteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXByteArray *)new GTXByteArray();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXByteArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXByteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jbyteArray jarg2) {
  jlong jresult = 0 ;
  gtx_long arg1 ;
  unsigned char *arg2 ;
  jbyte *jarr2 ;
  GTXByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (gtx_long)jarg1; 
  // GV typemap for unsigned char []
  if (!SWIG_JavaArrayInSchar(jenv, &jarr2, (signed char **)&arg2, jarg2)) return 0; 
  {
    try {
      result = (GTXByteArray *)new GTXByteArray(arg1,arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXByteArray **)&jresult = result; 
  // GV typemap for unsigned char []
  SWIG_JavaArrayArgoutSchar(jenv, jarr2, (signed char *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXByteArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXByteArray *arg1 = (GTXByteArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXByteArray **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXByteArray_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXByteArray *arg1 = 0 ;
  GTXByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXByteArray **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXByteArray const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXByteArray *)new GTXByteArray((GTXByteArray const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXByteArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXByteArray_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXByteArray *arg1 = (GTXByteArray *) 0 ;
  gtx_long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXByteArray **)&jarg1; 
  {
    try {
      result = ((GTXByteArray const *)arg1)->GetCount();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXByteArray_1Resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXByteArray *arg1 = (GTXByteArray *) 0 ;
  gtx_long arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXByteArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      (arg1)->Resize(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jshort JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXByteArray_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  GTXByteArray *arg1 = (GTXByteArray *) 0 ;
  gtx_long arg2 ;
  unsigned char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXByteArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      result = (unsigned char)((GTXByteArray const *)arg1)->GetValue(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXByteArray_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  GTXByteArray *arg1 = (GTXByteArray *) 0 ;
  gtx_long arg2 ;
  unsigned char arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXByteArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (unsigned char)jarg3; 
  {
    try {
      (arg1)->SetValue(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jbyteArray JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXByteArray_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  GTXByteArray *arg1 = (GTXByteArray *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXByteArray **)&jarg1; 
  {
    try {
      result = (unsigned char *)((GTXByteArray const *)arg1)->GetValues();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  {
    int count = (int)(arg1)->GetCount();
    if (result)
    {
      jresult = jenv->NewByteArray(count);
      jenv->SetByteArrayRegion(jresult, 0, count, (jbyte*)result);
    }
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXClient(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXClient *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXClient *)new GTXClient();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXClient **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetDebugMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->SetDebugMode(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetDefaultPort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (unsigned short)(arg1)->GetDefaultPort();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LocateGTXserver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->LocateGTXserver();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetGTXserverPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetGTXserverPath((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1RunGTXserver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  unsigned short arg2 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  {
    try {
      result = (unsigned short)(arg1)->RunGTXserver(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1Connect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jstring jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned short arg3 ;
  char *arg4 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (unsigned short)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  {
    try {
      (arg1)->Connect((char const *)arg2,arg3,(char const *)arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1IsConnected(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->IsConnected();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1Disconnect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      (arg1)->Disconnect();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetServerVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetServerVersion();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetStudyList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetStudyList();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetStudy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetStudy((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewStudy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      (arg1)->NewStudy((char const *)arg2,(char const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1DeleteStudy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      (arg1)->DeleteStudy();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetDirectoryList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetDirectoryList();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1DirectoryExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (bool)(arg1)->DirectoryExists((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetDirectory((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->NewDirectory((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1DeleteDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      (arg1)->DeleteDirectory();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetFileList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetFileList();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetFileList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXFileInfo::FileType arg2 ;
  int arg3 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (GTXFileInfo::FileType)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (arg1)->GetFileList(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1FileExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (bool)(arg1)->FileExists((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetFile((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1DeleteFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      (arg1)->DeleteFile();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetFileInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXFileInfo result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetFileInfo();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFileInfo **)&jresult = new GTXFileInfo((const GTXFileInfo &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetFileComment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetFileComment();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetFileComment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jstring jarg3) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      (arg1)->SetFileComment(arg2,(char const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewPointsFile2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jdoubleArray jarg4, jdoubleArray jarg5) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  gtx_long arg3 ;
  double *arg4 ;
  double *arg5 ;
  jdouble *jarr4 ;
  jdouble *jarr5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (gtx_long)jarg3; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr4, (double **)&arg4, jarg4)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr5, (double **)&arg5, jarg5)) return ; 
  {
    try {
      (arg1)->NewPointsFile2D((char const *)arg2,arg3,(double const (*))arg4,(double const (*))arg5);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr4, (double *)arg4, jarg4); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr5, (double *)arg5, jarg5); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] arg4; 
  delete [] arg5; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewPointsFile3D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jdoubleArray jarg4, jdoubleArray jarg5, jdoubleArray jarg6) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  gtx_long arg3 ;
  double *arg4 ;
  double *arg5 ;
  double *arg6 ;
  jdouble *jarr4 ;
  jdouble *jarr5 ;
  jdouble *jarr6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (gtx_long)jarg3; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr4, (double **)&arg4, jarg4)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr5, (double **)&arg5, jarg5)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr6, (double **)&arg6, jarg6)) return ; 
  {
    try {
      (arg1)->NewPointsFile3D((char const *)arg2,arg3,(double const (*))arg4,(double const (*))arg5,(double const (*))arg6);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr4, (double *)arg4, jarg4); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr5, (double *)arg5, jarg5); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr6, (double *)arg6, jarg6); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  delete [] arg4; 
  delete [] arg5; 
  delete [] arg6; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewGridFile2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jint jarg7, jint jarg8) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  int arg7 ;
  int arg8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  {
    try {
      (arg1)->NewGridFile2D((char const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewGridFile3D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jint jarg9, jint jarg10, jint jarg11) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  int arg9 ;
  int arg10 ;
  int arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (int)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  {
    try {
      (arg1)->NewGridFile3D((char const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewLinesFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->NewLinesFile((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1PointsFileAppend2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  double *arg3 ;
  double *arg4 ;
  jdouble *jarr3 ;
  jdouble *jarr4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr3, (double **)&arg3, jarg3)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr4, (double **)&arg4, jarg4)) return ; 
  {
    try {
      (arg1)->PointsFileAppend2D(arg2,(double const (*))arg3,(double const (*))arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr3, (double *)arg3, jarg3); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr4, (double *)arg4, jarg4); 
  delete [] arg3; 
  delete [] arg4; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1PointsFileAppend3D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdoubleArray jarg3, jdoubleArray jarg4, jdoubleArray jarg5) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  double *arg3 ;
  double *arg4 ;
  double *arg5 ;
  jdouble *jarr3 ;
  jdouble *jarr4 ;
  jdouble *jarr5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr3, (double **)&arg3, jarg3)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr4, (double **)&arg4, jarg4)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr5, (double **)&arg5, jarg5)) return ; 
  {
    try {
      (arg1)->PointsFileAppend3D(arg2,(double const (*))arg3,(double const (*))arg4,(double const (*))arg5);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr3, (double *)arg3, jarg3); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr4, (double *)arg4, jarg4); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr5, (double *)arg5, jarg5); 
  delete [] arg3; 
  delete [] arg4; 
  delete [] arg5; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileAddLineCores2DOld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdoubleArray jarg5, jdoubleArray jarg6) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double *arg5 ;
  double *arg6 ;
  jdouble *jarr5 ;
  jdouble *jarr6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr5, (double **)&arg5, jarg5)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr6, (double **)&arg6, jarg6)) return ; 
  {
    try {
      (arg1)->LinesFileAddLineCores2DOld(arg2,arg3,arg4,(double const (*))arg5,(double const (*))arg6);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr5, (double *)arg5, jarg5); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr6, (double *)arg6, jarg6); 
  delete [] arg5; 
  delete [] arg6; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileAddLineCores3DOld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdoubleArray jarg6, jdoubleArray jarg7, jdoubleArray jarg8) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double *arg6 ;
  double *arg7 ;
  double *arg8 ;
  jdouble *jarr6 ;
  jdouble *jarr7 ;
  jdouble *jarr8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr6, (double **)&arg6, jarg6)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr7, (double **)&arg7, jarg7)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr8, (double **)&arg8, jarg8)) return ; 
  {
    try {
      (arg1)->LinesFileAddLineCores3DOld(arg2,arg3,arg4,arg5,(double const (*))arg6,(double const (*))arg7,(double const (*))arg8);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr6, (double *)arg6, jarg6); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr7, (double *)arg7, jarg7); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr8, (double *)arg8, jarg8); 
  delete [] arg6; 
  delete [] arg7; 
  delete [] arg8; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileAddCoreLine2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdoubleArray jarg5, jdoubleArray jarg6) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double *arg5 ;
  double *arg6 ;
  jdouble *jarr5 ;
  jdouble *jarr6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr5, (double **)&arg5, jarg5)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr6, (double **)&arg6, jarg6)) return ; 
  {
    try {
      (arg1)->LinesFileAddCoreLine2D(arg2,arg3,arg4,(double const (*))arg5,(double const (*))arg6);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr5, (double *)arg5, jarg5); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr6, (double *)arg6, jarg6); 
  delete [] arg5; 
  delete [] arg6; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileAddCoreLine3D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdoubleArray jarg6, jdoubleArray jarg7, jdoubleArray jarg8) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double *arg6 ;
  double *arg7 ;
  double *arg8 ;
  jdouble *jarr6 ;
  jdouble *jarr7 ;
  jdouble *jarr8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr6, (double **)&arg6, jarg6)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr7, (double **)&arg7, jarg7)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr8, (double **)&arg8, jarg8)) return ; 
  {
    try {
      (arg1)->LinesFileAddCoreLine3D(arg2,arg3,arg4,arg5,(double const (*))arg6,(double const (*))arg7,(double const (*))arg8);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr6, (double *)arg6, jarg6); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr7, (double *)arg7, jarg7); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr8, (double *)arg8, jarg8); 
  delete [] arg6; 
  delete [] arg7; 
  delete [] arg8; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileAddGravityLine2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  double *arg3 ;
  double *arg4 ;
  jdouble *jarr3 ;
  jdouble *jarr4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr3, (double **)&arg3, jarg3)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr4, (double **)&arg4, jarg4)) return ; 
  {
    try {
      (arg1)->LinesFileAddGravityLine2D(arg2,(double const (*))arg3,(double const (*))arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr3, (double *)arg3, jarg3); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr4, (double *)arg4, jarg4); 
  delete [] arg3; 
  delete [] arg4; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileAddGravityLine3D(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdoubleArray jarg3, jdoubleArray jarg4, jdoubleArray jarg5) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  double *arg3 ;
  double *arg4 ;
  double *arg5 ;
  jdouble *jarr3 ;
  jdouble *jarr4 ;
  jdouble *jarr5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr3, (double **)&arg3, jarg3)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr4, (double **)&arg4, jarg4)) return ; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr5, (double **)&arg5, jarg5)) return ; 
  {
    try {
      (arg1)->LinesFileAddGravityLine3D(arg2,(double const (*))arg3,(double const (*))arg4,(double const (*))arg5);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr3, (double *)arg3, jarg3); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr4, (double *)arg4, jarg4); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr5, (double *)arg5, jarg5); 
  delete [] arg3; 
  delete [] arg4; 
  delete [] arg5; 
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1LinesFileCreateLink(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->LinesFileCreateLink((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GridModifyOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->GridModifyOrigin(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GridModifyMesh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->GridModifyMesh(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GridModifyRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->GridModifyRotation(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetVariableList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetVariableList();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetVariableList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXVariableInfo::VariableType arg2 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (GTXVariableInfo::VariableType)jarg2; 
  {
    try {
      result = (arg1)->GetVariableList(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1VariableExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (bool)(arg1)->VariableExists((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetVariable((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1DeleteVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      (arg1)->DeleteVariable();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetIndice(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->SetIndice(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetAlphaIndice(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetAlphaIndice((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetVariableInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXVariableInfo result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetVariableInfo();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVariableInfo **)&jresult = new GTXVariableInfo((const GTXVariableInfo &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetMacroIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXIntArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetMacroIndices();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXIntArray **)&jresult = new GTXIntArray((const GTXIntArray &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetMacroAlphaIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->GetMacroAlphaIndices();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1AddMacroIndicesWithAlpha(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXIntArray arg2 ;
  GTXStringArray arg3 ;
  GTXIntArray const *argp2 ;
  GTXStringArray const *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  argp2 = *(GTXIntArray **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null GTXIntArray const");
    return ;
  }
  arg2 = *argp2; 
  argp3 = *(GTXStringArray **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null GTXStringArray const");
    return ;
  }
  arg3 = *argp3; 
  {
    try {
      (arg1)->AddMacroIndicesWithAlpha(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1AddMacroIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXIntArray arg2 ;
  GTXIntArray const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXClient **)&jarg1; 
  argp2 = *(GTXIntArray **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null GTXIntArray const");
    return ;
  }
  arg2 = *argp2; 
  {
    try {
      (arg1)->AddMacroIndices(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadCharVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  GTXCharData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (arg1)->ReadCharVariable(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXCharData **)&jresult = new GTXCharData((const GTXCharData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadCharVariableSub(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  gtx_long arg3 ;
  bool arg4 ;
  GTXCharData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (gtx_long)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (arg1)->ReadCharVariableSub(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXCharData **)&jresult = new GTXCharData((const GTXCharData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadLineCharVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  GTXCharData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (arg1)->ReadLineCharVariable(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXCharData **)&jresult = new GTXCharData((const GTXCharData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadLineDoubleVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  GTXDoubleData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (arg1)->ReadLineDoubleVariable(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleData **)&jresult = new GTXDoubleData((const GTXDoubleData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadDoubleVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  GTXDoubleData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (arg1)->ReadDoubleVariable(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleData **)&jresult = new GTXDoubleData((const GTXDoubleData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadDoubleVariableSub(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  gtx_long arg3 ;
  bool arg4 ;
  GTXDoubleData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (gtx_long)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (arg1)->ReadDoubleVariableSub(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleData **)&jresult = new GTXDoubleData((const GTXDoubleData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadSelectionVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXByteArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->ReadSelectionVariable();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXByteArray **)&jresult = new GTXByteArray((const GTXByteArray &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadSelectionVariableSub(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  gtx_long arg3 ;
  GTXByteArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (gtx_long)jarg3; 
  {
    try {
      result = (arg1)->ReadSelectionVariableSub(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXByteArray **)&jresult = new GTXByteArray((const GTXByteArray &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewDoubleVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  GTXVariableFormat *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  arg4 = *(GTXVariableFormat **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXVariableFormat const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->NewDoubleVariable((char const *)arg2,arg3,(GTXVariableFormat const &)*arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewCharVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->NewCharVariable((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetVariableAsLineName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      (arg1)->SetVariableAsLineName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteDoubleVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  GTXDoubleData *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(GTXDoubleData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXDoubleData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->WriteDoubleVariable(arg2,(GTXDoubleData const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteDoubleVariableSub(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jboolean jarg4, jlong jarg5, jobject jarg5_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  gtx_long arg3 ;
  bool arg4 ;
  GTXDoubleData *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (gtx_long)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = *(GTXDoubleData **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXDoubleData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->WriteDoubleVariableSub(arg2,arg3,arg4,(GTXDoubleData const &)*arg5);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteLineDoubleVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  GTXDoubleData *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(GTXDoubleData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXDoubleData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->WriteLineDoubleVariable(arg2,(GTXDoubleData const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteCharVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  GTXCharData *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(GTXCharData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXCharData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->WriteCharVariable(arg2,(GTXCharData const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteCharVariableSub(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jboolean jarg4, jlong jarg5, jobject jarg5_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  gtx_long arg3 ;
  bool arg4 ;
  GTXCharData *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (gtx_long)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = *(GTXCharData **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXCharData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->WriteCharVariableSub(arg2,arg3,arg4,(GTXCharData const &)*arg5);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteLineCharVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  GTXCharData *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(GTXCharData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXCharData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->WriteLineCharVariable(arg2,(GTXCharData const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteSelectionVariableSub(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  gtx_long arg2 ;
  gtx_long arg3 ;
  GTXByteArray arg4 ;
  GTXByteArray const *argp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (gtx_long)jarg3; 
  argp4 = *(GTXByteArray **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null GTXByteArray const");
    return ;
  }
  arg4 = *argp4; 
  {
    try {
      (arg1)->WriteSelectionVariableSub(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteSelectionVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXByteArray arg2 ;
  GTXByteArray const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXClient **)&jarg1; 
  argp2 = *(GTXByteArray **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null GTXByteArray const");
    return ;
  }
  arg2 = *argp2; 
  {
    try {
      (arg1)->WriteSelectionVariable(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1GetVariableComment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetVariableComment();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetVariableComment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jstring jarg3) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  bool arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      (arg1)->SetVariableComment(arg2,(char const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetSelection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetSelection((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetVariableUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      (arg1)->SetVariableUnit((char const *)arg2,(char const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetUnit((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1UnitFactorFromSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (double)(arg1)->UnitFactorFromSymbol((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1UnitSymbolFromFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jstring jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  double arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (char *)(arg1)->UnitSymbolFromFactor(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetUnitMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->SetUnitMode(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1SetCreationUnits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  {
    try {
      (arg1)->SetCreationUnits((char const *)arg2,(char const *)arg3,(char const *)arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1VendorDataWrite(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  GTXVendorData *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(GTXVendorData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXVendorData const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->VendorDataWrite(arg2,(GTXVendorData const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1VendorDataRead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  SwigValueWrapper< GTXVendorData > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  {
    try {
      result = (arg1)->VendorDataRead((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVendorData **)&jresult = new GTXVendorData((const GTXVendorData &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1VendorDataExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  {
    try {
      result = (bool)(arg1)->VendorDataExists((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1VendorDataGetVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  {
    try {
      result = (int)(arg1)->VendorDataGetVersion((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadFaults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  int arg2 ;
  GTXFaultSystem result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (arg1)->ReadFaults(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultSystem **)&jresult = new GTXFaultSystem((const GTXFaultSystem &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1WriteFaults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXFaultSystem arg2 ;
  GTXFaultSystem *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXClient **)&jarg1; 
  argp2 = *(GTXFaultSystem **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null GTXFaultSystem");
    return ;
  }
  arg2 = *argp2; 
  {
    try {
      (arg1)->WriteFaults(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewPolygonsFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXPolygonSystem *arg3 = (GTXPolygonSystem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(GTXPolygonSystem **)&jarg3; 
  {
    try {
      (arg1)->NewPolygonsFile((char const *)arg2,(GTXPolygonSystem const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadPolygons(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXPolygonSystem result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->ReadPolygons();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXPolygonSystem **)&jresult = new GTXPolygonSystem((const GTXPolygonSystem &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1NewWireframesFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXWireframeSystem *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXClient **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(GTXWireframeSystem **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXWireframeSystem const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->NewWireframesFile((char const *)arg2,(GTXWireframeSystem const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXClient_1ReadWireframes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXClient *arg1 = (GTXClient *) 0 ;
  GTXWireframeSystem result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      result = (arg1)->ReadWireframes();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframeSystem **)&jresult = new GTXWireframeSystem((const GTXWireframeSystem &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXClient(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXClient *arg1 = (GTXClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXClient **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXDoubleArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXDoubleArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXDoubleArray *)new GTXDoubleArray();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXDoubleArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jdoubleArray jarg2) {
  jlong jresult = 0 ;
  gtx_long arg1 ;
  double *arg2 ;
  jdouble *jarr2 ;
  GTXDoubleArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (gtx_long)jarg1; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, (double **)&arg2, jarg2)) return 0; 
  {
    try {
      result = (GTXDoubleArray *)new GTXDoubleArray(arg1,arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleArray **)&jresult = result; 
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, (double *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXDoubleArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXDoubleArray_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXDoubleArray *arg1 = 0 ;
  GTXDoubleArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXDoubleArray const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXDoubleArray *)new GTXDoubleArray((GTXDoubleArray const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleArray_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  gtx_long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  {
    try {
      result = ((GTXDoubleArray const *)arg1)->GetCount();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleArray_1Resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  gtx_long arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      (arg1)->Resize(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleArray_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  gtx_long arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      result = (double)((GTXDoubleArray const *)arg1)->GetValue(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdoubleArray JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleArray_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  {
    try {
      result = (double *)((GTXDoubleArray const *)arg1)->GetValues();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  {
    int count = (int)(arg1)->GetCount();
    if (result)
    {
      jresult = jenv->NewDoubleArray(count);
      jenv->SetDoubleArrayRegion(jresult, 0, count, result);
    }
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleArray_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  gtx_long arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetValue(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleArray_1SetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  GTXDoubleArray *arg1 = (GTXDoubleArray *) 0 ;
  double *arg2 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleArray **)&jarg1; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, (double **)&arg2, jarg2)) return ; 
  {
    try {
      (arg1)->SetValues(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, (double *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFault_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXFault *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXFault *)new GTXFault();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFault **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFault_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXFault *arg1 = 0 ;
  GTXFault *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFault const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXFault *)new GTXFault((GTXFault const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFault **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXFault(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXFault *arg1 = (GTXFault *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXFault **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFault *arg1 = (GTXFault *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1; 
  {
    try {
      result = (char *)((GTXFault const *)arg1)->GetName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1GetPolygonalFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFault *arg1 = (GTXFault *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1; 
  {
    try {
      result = (bool)((GTXFault const *)arg1)->GetPolygonalFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1GetSegmentsNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFault *arg1 = (GTXFault *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1; 
  {
    try {
      result = (int)((GTXFault const *)arg1)->GetSegmentsNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1GetSegment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXFault *arg1 = (GTXFault *) 0 ;
  int arg2 ;
  GTXFaultSegment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = ((GTXFault const *)arg1)->GetSegment(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultSegment **)&jresult = new GTXFaultSegment((const GTXFaultSegment &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1SetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXFault *arg1 = (GTXFault *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetName((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1SetPolygonalFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  GTXFault *arg1 = (GTXFault *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFault **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->SetPolygonalFlag(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFault_1AddFaultSegment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXFault *arg1 = (GTXFault *) 0 ;
  GTXFaultSegment *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXFault **)&jarg1; 
  arg2 = *(GTXFaultSegment **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFaultSegment const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddFaultSegment((GTXFaultSegment const &)*arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFaultInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXFaultInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXFaultInfo *)new GTXFaultInfo();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFaultInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXFaultInfo *arg1 = 0 ;
  GTXFaultInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFaultInfo const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXFaultInfo *)new GTXFaultInfo((GTXFaultInfo const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetFaults2DFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetFaults2DFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetAuxiliaryVarUsedFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetAuxiliaryVarUsedFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetFaultsNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetFaultsNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetSegmentsNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetSegmentsNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetMinimumPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetMinimumPriority();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetMaximumPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetMaximumPriority();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultInfo_1GetAuthorizedPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetAuthorizedPriority();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXFaultInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXFaultInfo *arg1 = (GTXFaultInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXFaultInfo **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFaultSegment_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXFaultSegment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXFaultSegment *)new GTXFaultSegment();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultSegment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFaultSegment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXFaultSegment *arg1 = 0 ;
  GTXFaultSegment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFaultSegment const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXFaultSegment *)new GTXFaultSegment((GTXFaultSegment const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultSegment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXFaultSegment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetX1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetX1();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetY1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetY1();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetZ1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetZ1();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetX2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetX2();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetY2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetY2();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetZ2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetZ2();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetX3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetX3();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetY3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetY3();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetZ3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetZ3();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetV1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetV1();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetV2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetV2();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetV3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSegment const *)arg1)->GetV3();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1GetPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  {
    try {
      result = (int)((GTXFaultSegment const *)arg1)->GetPriority();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetX1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetX1(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetY1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetY1(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetZ1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetZ1(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetX2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetX2(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetY2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetY2(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetZ2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetZ2(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetX3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetX3(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetY3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetY3(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetZ3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetZ3(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetV1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetV1(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetV2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetV2(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetV3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetV3(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSegment_1SetPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXFaultSegment *arg1 = (GTXFaultSegment *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSegment **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->SetPriority(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFaultSystem_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXFaultSystem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXFaultSystem *)new GTXFaultSystem();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultSystem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFaultSystem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXFaultSystem *arg1 = 0 ;
  GTXFaultSystem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFaultSystem const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXFaultSystem *)new GTXFaultSystem((GTXFaultSystem const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultSystem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXFaultSystem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1GetFaults2DFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  {
    try {
      result = (bool)((GTXFaultSystem const *)arg1)->GetFaults2DFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1GetAuxiliaryVarUsedFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  {
    try {
      result = (bool)((GTXFaultSystem const *)arg1)->GetAuxiliaryVarUsedFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1GetAuxiliaryVarTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXFaultSystem const *)arg1)->GetAuxiliaryVarTest();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1GetFaultsNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  {
    try {
      result = (int)((GTXFaultSystem const *)arg1)->GetFaultsNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1GetFault(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  int arg2 ;
  GTXFault result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = ((GTXFaultSystem const *)arg1)->GetFault(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFault **)&jresult = new GTXFault((const GTXFault &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1SetFaults2DFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->SetFaults2DFlag(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1SetAuxiliaryVarUsedFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->SetAuxiliaryVarUsedFlag(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1SetAuxiliaryVarTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetAuxiliaryVarTest(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFaultSystem_1AddFault(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXFaultSystem *arg1 = (GTXFaultSystem *) 0 ;
  GTXFault *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXFaultSystem **)&jarg1; 
  arg2 = *(GTXFault **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFault const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddFault((GTXFault const &)*arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFileInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXFileInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXFileInfo *)new GTXFileInfo();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFileInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXFileInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXFileInfo *arg1 = 0 ;
  GTXFileInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXFileInfo const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXFileInfo *)new GTXFileInfo((GTXFileInfo const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFileInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetFileType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  GTXFileInfo::FileType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (GTXFileInfo::FileType)(arg1)->GetFileType();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetLinkedFileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetLinkedFileName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetFaultedFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetFaultedFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetPolygonFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetPolygonFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetDimension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetDimension();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetSampleNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  gtx_long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (arg1)->GetSampleNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetItemNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetItemNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridX0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridX0();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridY0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridY0();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridZ0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridZ0();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridDX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridDX();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridDY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridDY();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridDZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridDZ();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridNX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetGridNX();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridNY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetGridNY();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridNZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetGridNZ();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridRotatedFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetGridRotatedFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridAngleAroundZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridAngleAroundZ();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridAngleAroundY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridAngleAroundY();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetGridAngleAroundX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (double)(arg1)->GetGridAngleAroundX();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetSampleNumberVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetSampleNumberVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetLineNameVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetLineNameVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetLineNumberVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetLineNumberVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetRelativeNumberVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetRelativeNumberVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetXCoordinateVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetXCoordinateVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetYCoordinateVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetYCoordinateVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetZCoordinateVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetZCoordinateVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetXCoreBeginVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetXCoreBeginVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetYCoreBeginVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetYCoreBeginVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetZCoreBeginVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetZCoreBeginVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetXCoreEndVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetXCoreEndVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetYCoreEndVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetYCoreEndVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetZCoreEndVariableName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetZCoreEndVariableName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXFileInfo_1GetFaultInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  GTXFaultInfo result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      result = (arg1)->GetFaultInfo();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXFaultInfo **)&jresult = new GTXFaultInfo((const GTXFaultInfo &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXFileInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXFileInfo *arg1 = (GTXFileInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXFileInfo **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXIntArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXIntArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXIntArray *)new GTXIntArray();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXIntArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXIntArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jintArray jarg2) {
  jlong jresult = 0 ;
  gtx_long arg1 ;
  int *arg2 ;
  jint *jarr2 ;
  GTXIntArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (gtx_long)jarg1; 
  if (!SWIG_JavaArrayInInt(jenv, &jarr2, (int **)&arg2, jarg2)) return 0; 
  {
    try {
      result = (GTXIntArray *)new GTXIntArray(arg1,arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXIntArray **)&jresult = result; 
  SWIG_JavaArrayArgoutInt(jenv, jarr2, (int *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXIntArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXIntArray *arg1 = (GTXIntArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXIntArray **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXIntArray_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXIntArray *arg1 = 0 ;
  GTXIntArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXIntArray **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXIntArray const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXIntArray *)new GTXIntArray((GTXIntArray const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXIntArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXIntArray_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXIntArray *arg1 = (GTXIntArray *) 0 ;
  gtx_long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXIntArray **)&jarg1; 
  {
    try {
      result = ((GTXIntArray const *)arg1)->GetCount();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXIntArray_1Resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXIntArray *arg1 = (GTXIntArray *) 0 ;
  gtx_long arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXIntArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      (arg1)->Resize(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXIntArray_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  GTXIntArray *arg1 = (GTXIntArray *) 0 ;
  gtx_long arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXIntArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      result = (int)((GTXIntArray const *)arg1)->GetValue(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXIntArray_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  GTXIntArray *arg1 = (GTXIntArray *) 0 ;
  gtx_long arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXIntArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->SetValue(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jintArray JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXIntArray_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  GTXIntArray *arg1 = (GTXIntArray *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXIntArray **)&jarg1; 
  {
    try {
      result = (int *)((GTXIntArray const *)arg1)->GetValues();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  {
    int count = (int)(arg1)->GetCount();
    if (result)
    {
      jresult = jenv->NewIntArray(count);
      // Windows JNI has jint being long
      jenv->SetIntArrayRegion(jresult, 0, count, (jint*)result);
    }
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXPolygon_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXPolygon *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXPolygon *)new GTXPolygon();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXPolygon **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXPolygon_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXPolygon *arg1 = 0 ;
  GTXPolygon *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXPolygon const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXPolygon *)new GTXPolygon((GTXPolygon const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXPolygon **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXPolygon(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXPolygon **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  {
    try {
      result = (char *)((GTXPolygon const *)arg1)->GetName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetGroupName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  {
    try {
      result = (char *)((GTXPolygon const *)arg1)->GetGroupName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetZMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygon const *)arg1)->GetZMin();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetZMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygon const *)arg1)->GetZMax();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetVerticesNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  {
    try {
      result = (int)((GTXPolygon const *)arg1)->GetVerticesNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetXVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (double)((GTXPolygon const *)arg1)->GetXVertices(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1GetYVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (double)((GTXPolygon const *)arg1)->GetYVertices(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1SetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetName((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1SetGroupName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetGroupName((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1SetZMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetZMin(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1SetZMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetZMax(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygon_1AddVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  GTXPolygon *arg1 = (GTXPolygon *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygon **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->AddVertex(arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXPolygonSystem_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXPolygonSystem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXPolygonSystem *)new GTXPolygonSystem();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXPolygonSystem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXPolygonSystem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXPolygonSystem *arg1 = 0 ;
  GTXPolygonSystem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXPolygonSystem const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXPolygonSystem *)new GTXPolygonSystem((GTXPolygonSystem const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXPolygonSystem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXPolygonSystem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetPolygons2DFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (bool)((GTXPolygonSystem const *)arg1)->GetPolygons2DFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetMinimumExtensionX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygonSystem const *)arg1)->GetMinimumExtensionX();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetMinimumExtensionY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygonSystem const *)arg1)->GetMinimumExtensionY();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetMinimumExtensionZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygonSystem const *)arg1)->GetMinimumExtensionZ();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetMaximumExtensionX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygonSystem const *)arg1)->GetMaximumExtensionX();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetMaximumExtensionY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygonSystem const *)arg1)->GetMaximumExtensionY();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetMaximumExtensionZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = (double)((GTXPolygonSystem const *)arg1)->GetMaximumExtensionZ();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetPolygonsNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  gtx_long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  {
    try {
      result = ((GTXPolygonSystem const *)arg1)->GetPolygonsNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1GetPolygon(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  int arg2 ;
  GTXPolygon result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = ((GTXPolygonSystem const *)arg1)->GetPolygon(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXPolygon **)&jresult = new GTXPolygon((const GTXPolygon &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1SetPolygons2DFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->SetPolygons2DFlag(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXPolygonSystem_1AddPolygon(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXPolygonSystem *arg1 = (GTXPolygonSystem *) 0 ;
  GTXPolygon *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXPolygonSystem **)&jarg1; 
  arg2 = *(GTXPolygon **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXPolygon const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddPolygon((GTXPolygon const &)*arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXStringArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXStringArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXStringArray *)new GTXStringArray();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXStringArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXStringArray *arg1 = (GTXStringArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXStringArray **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXStringArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXStringArray *arg1 = 0 ;
  GTXStringArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXStringArray **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXStringArray const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXStringArray *)new GTXStringArray((GTXStringArray const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXStringArray_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXStringArray *arg1 = (GTXStringArray *) 0 ;
  gtx_long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXStringArray **)&jarg1; 
  {
    try {
      result = ((GTXStringArray const *)arg1)->GetCount();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXStringArray_1Resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXStringArray *arg1 = (GTXStringArray *) 0 ;
  gtx_long arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXStringArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      (arg1)->Resize(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXStringArray_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  GTXStringArray *arg1 = (GTXStringArray *) 0 ;
  gtx_long arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXStringArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  {
    try {
      result = (char *)((GTXStringArray const *)arg1)->GetValue(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXStringArray_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  GTXStringArray *arg1 = (GTXStringArray *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXStringArray **)&jarg1; 
  {
    try {
      result = (char **)((GTXStringArray const *)arg1)->GetValues();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  {
    int count = (int)(arg1)->GetCount();
    if (result)
    {
      jresult = (jobjectArray)jenv->NewObjectArray(count,
        jenv->FindClass("java/lang/String"),
        jenv->NewStringUTF(""));
      
      for (int i = 0; i < count; i++) {
        jenv->SetObjectArrayElement(
          jresult, i, jenv->NewStringUTF(result[i]));
      }
    }
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXStringArray_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  GTXStringArray *arg1 = (GTXStringArray *) 0 ;
  gtx_long arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXStringArray **)&jarg1; 
  arg2 = (gtx_long)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      (arg1)->SetValue(arg2,(char const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXVariableFormat(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXVariableFormat *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXVariableFormat *)new GTXVariableFormat();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVariableFormat **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1SetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  GTXVariableFormat::FormatType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  arg2 = (GTXVariableFormat::FormatType)jarg2; 
  {
    try {
      (arg1)->SetType(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1GetFormatType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  GTXVariableFormat::FormatType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  {
    try {
      result = (GTXVariableFormat::FormatType)(arg1)->GetFormatType();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1SetLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->SetLength(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1GetLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetLength();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1SetDigits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->SetDigits(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1GetDigits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetDigits();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1SetUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetUnit((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableFormat_1GetUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetUnit();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXVariableFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXVariableFormat *arg1 = (GTXVariableFormat *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXVariableFormat **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXVariableInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXVariableInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXVariableInfo *)new GTXVariableInfo();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVariableInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXVariableInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXVariableInfo *arg1 = 0 ;
  GTXVariableInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXVariableInfo const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXVariableInfo *)new GTXVariableInfo((GTXVariableInfo const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVariableInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetVariableType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  GTXVariableInfo::VariableType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (GTXVariableInfo::VariableType)(arg1)->GetVariableType();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetBitLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetBitLength();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetAlphaLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetAlphaLength();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetImplicitFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetImplicitFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetIndicesNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (int)(arg1)->GetIndicesNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetUnit();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetUnitSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->GetUnitSymbol();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVariableInfo_1GetLengthFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->GetLengthFlag();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXVariableInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXVariableInfo *arg1 = (GTXVariableInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXVariableInfo **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXVendorData_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  GTXVendorData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  {
    try {
      result = (GTXVendorData *)new GTXVendorData((char const *)arg1,arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVendorData **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXVendorData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXVendorData *arg1 = 0 ;
  GTXVendorData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXVendorData const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXVendorData *)new GTXVendorData((GTXVendorData const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXVendorData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXVendorData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXVendorData **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1AddAttributeInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->AddAttributeInt((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1AddAttributeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->AddAttributeDouble((char const *)arg2,arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1AddAttributeString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      (arg1)->AddAttributeString((char const *)arg2,(char const *)arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1AddAttributeIntArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXIntArray *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(GTXIntArray **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXIntArray const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddAttributeIntArray((char const *)arg2,(GTXIntArray const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1AddAttributeDoubleArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXDoubleArray *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(GTXDoubleArray **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXDoubleArray const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddAttributeDoubleArray((char const *)arg2,(GTXDoubleArray const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1AddAttributeStringArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXStringArray *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(GTXStringArray **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXStringArray const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddAttributeStringArray((char const *)arg2,(GTXStringArray const &)*arg3);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  {
    try {
      result = (int)((GTXVendorData const *)arg1)->GetVersion();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  {
    try {
      result = (char *)((GTXVendorData const *)arg1)->GetIdentifier();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetAttributeInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (int)((GTXVendorData const *)arg1)->GetAttributeInt((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetAttributeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (double)((GTXVendorData const *)arg1)->GetAttributeDouble((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetAttributeString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (char *)((GTXVendorData const *)arg1)->GetAttributeString((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetAttributeIntArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXIntArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = ((GTXVendorData const *)arg1)->GetAttributeIntArray((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXIntArray **)&jresult = new GTXIntArray((const GTXIntArray &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetAttributeDoubleArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXDoubleArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = ((GTXVendorData const *)arg1)->GetAttributeDoubleArray((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleArray **)&jresult = new GTXDoubleArray((const GTXDoubleArray &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXVendorData_1GetAttributeStringArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  GTXVendorData *arg1 = (GTXVendorData *) 0 ;
  char *arg2 = (char *) 0 ;
  GTXStringArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXVendorData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = ((GTXVendorData const *)arg1)->GetAttributeStringArray((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXStringArray **)&jresult = new GTXStringArray((const GTXStringArray &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXWireframe_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXWireframe *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXWireframe *)new GTXWireframe();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframe **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXWireframe_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXWireframe *arg1 = 0 ;
  GTXWireframe *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXWireframe const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXWireframe *)new GTXWireframe((GTXWireframe const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframe **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXWireframe(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXWireframe **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  {
    try {
      result = (char *)((GTXWireframe const *)arg1)->GetName();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1GetColorR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframe const *)arg1)->GetColorR();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1GetColorG(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframe const *)arg1)->GetColorG();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1GetColorB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframe const *)arg1)->GetColorB();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1GetObjectsNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframe const *)arg1)->GetObjectsNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1GetWireframeObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  int arg2 ;
  GTXWireframeObject result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = ((GTXWireframe const *)arg1)->GetWireframeObject(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframeObject **)&jresult = new GTXWireframeObject((const GTXWireframeObject &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1SetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetName((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1SetColorRGB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframe **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  {
    try {
      (arg1)->SetColorRGB(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframe_1AddObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXWireframe *arg1 = (GTXWireframe *) 0 ;
  GTXWireframeObject *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXWireframe **)&jarg1; 
  arg2 = *(GTXWireframeObject **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXWireframeObject const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddObject((GTXWireframeObject const &)*arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXWireframeObject_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXWireframeObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXWireframeObject *)new GTXWireframeObject();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframeObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXWireframeObject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXWireframeObject *arg1 = 0 ;
  GTXWireframeObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXWireframeObject const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXWireframeObject *)new GTXWireframeObject((GTXWireframeObject const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframeObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXWireframeObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetVerticesNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframeObject const *)arg1)->GetVerticesNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetVertexX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (double)((GTXWireframeObject const *)arg1)->GetVertexX(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetVertexY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (double)((GTXWireframeObject const *)arg1)->GetVertexY(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetVertexZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (double)((GTXWireframeObject const *)arg1)->GetVertexZ(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetTrianglesNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframeObject const *)arg1)->GetTrianglesNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetTrianglePt1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((GTXWireframeObject const *)arg1)->GetTrianglePt1(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetTrianglePt2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((GTXWireframeObject const *)arg1)->GetTrianglePt2(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1GetTrianglePt3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((GTXWireframeObject const *)arg1)->GetTrianglePt3(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1AddVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->AddVertex(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeObject_1AddTriangle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  GTXWireframeObject *arg1 = (GTXWireframeObject *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeObject **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  {
    try {
      (arg1)->AddTriangle(arg2,arg3,arg4);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXWireframeSystem_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXWireframeSystem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXWireframeSystem *)new GTXWireframeSystem();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframeSystem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXWireframeSystem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXWireframeSystem *arg1 = 0 ;
  GTXWireframeSystem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeSystem **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXWireframeSystem const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXWireframeSystem *)new GTXWireframeSystem((GTXWireframeSystem const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframeSystem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXWireframeSystem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXWireframeSystem *arg1 = (GTXWireframeSystem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXWireframeSystem **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeSystem_1GetWireframesNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GTXWireframeSystem *arg1 = (GTXWireframeSystem *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeSystem **)&jarg1; 
  {
    try {
      result = (int)((GTXWireframeSystem const *)arg1)->GetWireframesNumber();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeSystem_1GetWireframe(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  GTXWireframeSystem *arg1 = (GTXWireframeSystem *) 0 ;
  int arg2 ;
  GTXWireframe result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXWireframeSystem **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = ((GTXWireframeSystem const *)arg1)->GetWireframe(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXWireframe **)&jresult = new GTXWireframe((const GTXWireframe &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXWireframeSystem_1AddWireframe(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  GTXWireframeSystem *arg1 = (GTXWireframeSystem *) 0 ;
  GTXWireframe *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(GTXWireframeSystem **)&jarg1; 
  arg2 = *(GTXWireframe **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXWireframe const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->AddWireframe((GTXWireframe const &)*arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXCharData_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXCharData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXCharData *)new GTXCharData();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXCharData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXCharData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXCharData *arg1 = (GTXCharData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXCharData **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXCharData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXCharData *arg1 = 0 ;
  GTXCharData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXCharData **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXCharData const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXCharData *)new GTXCharData((GTXCharData const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXCharData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXCharData_1GetUndefinedValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  GTXCharData *arg1 = (GTXCharData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXCharData **)&jarg1; 
  {
    try {
      result = (char *)((GTXCharData const *)arg1)->GetUndefinedValue();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXCharData_1SetUndefinedValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  GTXCharData *arg1 = (GTXCharData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXCharData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->SetUndefinedValue((char const *)arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXDoubleData_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GTXDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (GTXDoubleData *)new GTXDoubleData();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXDoubleData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jdoubleArray jarg2) {
  jlong jresult = 0 ;
  gtx_long arg1 ;
  double *arg2 ;
  jdouble *jarr2 ;
  GTXDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (gtx_long)jarg1; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, (double **)&arg2, jarg2)) return 0; 
  {
    try {
      result = (GTXDoubleData *)new GTXDoubleData(arg1,arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleData **)&jresult = result; 
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, (double *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_delete_1GTXDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GTXDoubleData *arg1 = (GTXDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GTXDoubleData **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_new_1GTXDoubleData_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  GTXDoubleData *arg1 = 0 ;
  GTXDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleData **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GTXDoubleData const & reference is null");
    return 0;
  } 
  {
    try {
      result = (GTXDoubleData *)new GTXDoubleData((GTXDoubleData const &)*arg1);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  *(GTXDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleData_1GetUndefinedValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  GTXDoubleData *arg1 = (GTXDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleData **)&jarg1; 
  {
    try {
      result = (double)((GTXDoubleData const *)arg1)->GetUndefinedValue();
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return 0;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleData_1SetUndefinedValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  GTXDoubleData *arg1 = (GTXDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GTXDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetUndefinedValue(arg2);
    } catch(GTXError & reason) {
      jclass excep = jenv->FindClass("com/geovariances/gtxclient/GTXError");
      if (excep)
      jenv->ThrowNew(excep, reason.GetMessage());
      return ;
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXCharData_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(GTXStringArray **)&baseptr = *(GTXCharData **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_geovariances_gtxclient_GTXClientWrapperJNI_GTXDoubleData_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(GTXDoubleArray **)&baseptr = *(GTXDoubleData **)&jarg1;
    return baseptr;
}

#ifdef __cplusplus
}
#endif

