/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: messages.c 25987 2016-04-26 09:15:49Z foucher $";

#include <stdarg.h>
#include <string.h> /* strerror */
#include <errno.h> /* errno */
#if !defined(winnt)
#include <netinet/in.h>
#include <netdb.h>
#endif

int _gtx_client_dbg_mode = 0;

static void st_def_error(const char *string);
void (*GTX_ERROR_FUNCTION)(const char *string) = st_def_error;
 
#if defined(winnt)
typedef struct _WSAErrorCode
{
 int  dcode;
 LPCSTR msg;
 int  mcode;
} WSAErrorCode;

static WSAErrorCode WSAErrCodes[] =
{
  0, "No error", 0,
 10004, "A blocking operation was interrupted by a call to WSACancelBlockingCall", WSAEINTR,
 10009, "The file handle supplied is not valid", WSAEBADF,
 10013, "An attempt was made to access a socket in a way forbidden by its access permissions",WSAEACCES,
 10014, "The system detected an invalid pointer address in attempting to use a pointer argument in a call",WSAEFAULT,
 10022, "An invalid argument was supplied",WSAEINVAL,
 10024, "Too many open sockets",WSAEMFILE,
 10035, "A non-blocking socket operation could not be completed immediately",WSAEWOULDBLOCK,
 10036, "A blocking operation is currently executing",WSAEINPROGRESS,
 10037, "An operation was attempted on a non-blocking socket that already had an operation in progress",WSAEALREADY,
 10038, "An operation was attempted on something that is not a socket",WSAENOTSOCK,
 10039, "A required address was omitted from an operation on a socket",WSAEDESTADDRREQ,
 10040, "A message sent on a datagram socket was larger than the internal message buffer or some other network limit, or the buffer used to receive a datagram into was smaller than the datagram itself",WSAEMSGSIZE,
 10041, "A protocol was specified in the socket function call that does not support the semantics of the socket type requested",WSAEPROTOTYPE,
 10042, "An unknown, invalid, or unsupported option or level was specified in a getsockopt or setsockopt call",WSAENOPROTOOPT,
 10043, "The requested protocol has not been configured into the system, or no implementation for it exists",WSAEPROTONOSUPPORT,
 10044, "The support for the specified socket type does not exist in this address family",WSAESOCKTNOSUPPORT,
 10045, "The attempted operation is not supported for the type of object referenced",WSAEOPNOTSUPP,
 10046, "The protocol family has not been configured into the system or no implementation for it exists",WSAEPFNOSUPPORT,
 10047, "An address incompatible with the requested protocol was used",WSAEAFNOSUPPORT,
 10048, "Only one usage of each socket address (protocol/network address/port) is normally permitted",WSAEADDRINUSE,
 10049, "The requested address is not valid in its context",WSAEADDRNOTAVAIL,
 10050, "A socket operation encountered a dead network",WSAENETDOWN,
 10051, "A socket operation was attempted to an unreachable network",WSAENETUNREACH,
 10052, "The connection has been broken due to keep-alive activity detecting a failure while the operation was in progress",WSAENETRESET,
 10053, "An established connection was aborted by the software in your host machine",WSAECONNABORTED,
 10054, "An existing connection was forcibly closed by the remote host",WSAECONNRESET,
 10055, "An operation on a socket could not be performed because the system lacked sufficient buffer space or because a queue was full",WSAENOBUFS,
 10056, "A connect request was made on an already connected socket",WSAEISCONN,
 10057, "A request to send or receive data was disallowed because the socket is not connected and (when sending on a datagram socket using a sendto call) no address was supplied",WSAENOTCONN,
 10058, "A request to send or receive data was disallowed because the socket had already been shut down in that direction with a previous shutdown call",WSAESHUTDOWN,
 10059, "Too many references to some kernel object",WSAETOOMANYREFS,
 10060, "A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond",WSAETIMEDOUT,
 10061, "No connection could be made because the target machine actively refused it",WSAECONNREFUSED,
 10062, "Cannot translate name",WSAELOOP,
 10063, "Name component or name was too long",WSAENAMETOOLONG,
 10064, "A socket operation failed because the destination host was down",WSAEHOSTDOWN,
 10065, "A socket operation was attempted to an unreachable host",WSAEHOSTUNREACH,
 10066, "Cannot remove a directory that is not empty",WSAENOTEMPTY,
 10067, "A Windows Sockets implementation may have a limit on the number of applications that may use it simultaneously",WSAEPROCLIM,
 10068, "Ran out of quota",WSAEUSERS,
 10069, "Ran out of disk quota",WSAEDQUOT,
 10070, "File handle reference is no longer available",WSAESTALE,
 10071, "Item is not available locally",WSAEREMOTE,
 10091, "WSAStartup cannot function at this time because the underlying system it uses to provide network services is currently unavailable",WSASYSNOTREADY,
 10092, "The Windows Sockets version requested is not supported",WSAVERNOTSUPPORTED,
 10093, "Either the application has not called WSAStartup, or WSAStartup failed",WSANOTINITIALISED,
 10101, "Returned by WSARecv or WSARecvFrom to indicate the remote party has initiated a graceful shutdown sequence",WSAEDISCON,
// 10103, "A call to WSALookupServiceEnd was made while this call was still processing. The call has been canceled",WSAECANCELLED,
// 10104, "The procedure call table is invalid",WSAEINVALIDPROCTABLE,
// 10105, "The requested service provider is invalid",WSAEINVALIDPROVIDER,
// 10106, "The requested service provider could not be loaded or initialized",WSAEPROVIDERFAILEDINIT,
// 10107, "A system call that should never fail has failed",WSASYSCALLFAILURE,
// 10108, "No such service is known. The service cannot be found in the specified name space",WSASERVICE_NOT_FOUND,
// 10109, "The specified class was not found",WSATYPE_NOT_FOUND,
// 10110, "No more results can be returned by WSALookupServiceNext",WSA_E_NO_MORE,
// 10111, "A call to WSALookupServiceEnd was made while this call was still processing. The call has been canceled",WSA_E_CANCELLED,
// 10112, "A database query failed because it was actively refused",WSAEREFUSED,
 11001, "No such host is known",WSAHOST_NOT_FOUND,
 11002, "This is usually a temporary error during hostname resolution and means that the local server did not receive a response from an authoritative server",WSATRY_AGAIN,
 11003, "A non-recoverable error occurred during a database lookup",WSANO_RECOVERY,
 11004, "The requested name is valid and was found in the database, but it does not have the correct associated data being resolved for",WSANO_DATA
// 11005, "At least one reserve has arrived",WSA_QOS_RECEIVERS,
// 11006, "At least one path has arrived",WSA_QOS_SENDERS,
// 11007, "There are no senders",WSA_QOS_NO_SENDERS,
// 11008, "There are no receivers",WSA_QOS_NO_RECEIVERS,
// 11009, "Reserve has been confirmed",WSA_QOS_REQUEST_CONFIRMED,
// 11010, "Error due to lack of resources",WSA_QOS_ADMISSION_FAILURE,
// 11011, "Rejected for administrative reasons - bad credentials",WSA_QOS_POLICY_FAILURE,
// 11012, "Unknown or conflicting style",WSA_QOS_BAD_STYLE,
// 11013, "Problem with some part of the filterspec or providerspecific buffer in general",WSA_QOS_BAD_OBJECT,
// 11014, "Problem with some part of the flowspec", WSA_QOS_TRAFFIC_CTRL_ERROR,
// 11015, "General QOS error", WSA_QOS_GENERIC_ERROR
};
#endif

/****************************************************************************
**
** FUNCTION:    _gtx_debug
**
** DESCRIPTION: Print a debug message if in debug mode, a la printf
**
** IN_ARGS:     format: printf format
**
*****************************************************************************/
void _gtx_debug(char *format, ...)
{
  va_list ap;
  char buffer[1024];
 
  if (!_gtx_client_dbg_mode && _gtx_trace_level == 0) return;
  
  va_start(ap, format);
  (void)vsnprintf(buffer, sizeof(buffer), format, ap);
  va_end(ap);
 
  GTX_TRACE(1, ("Debug: %s", buffer));
  if (!_gtx_client_dbg_mode) return;
  fprintf(stdout, "%s Debug: %s\n",
          (_gtx_is_server)? "GTXserver" : "GTXClient",
          buffer);
}

/****************************************************************************
**
** FUNCTION:    st_def_error
**
** DESCRIPTION: Default error handling routine
**
** IN_ARGS:     string: string to be printed as error
**
*****************************************************************************/
static void st_def_error(const char *string)
{
  fprintf(stderr, "%s ERROR: %s\n",
          (_gtx_is_server)? "GTXserver" : "GTXClient",
          string);
}

/****************************************************************************
**
** FUNCTION:    _gtx_error
**
** DESCRIPTION: Print an error message, a la printf
**
** IN_ARGS:     format: printf format
**
*****************************************************************************/
void _gtx_error(char *format, ...)
{
  va_list ap;
  char buffer[1024];
 
  va_start(ap, format);
  (void)vsnprintf(buffer, sizeof(buffer), format, ap);
  va_end(ap);
 
  GTX_TRACE(1, ("Error: %s", buffer));
  (*GTX_ERROR_FUNCTION)(buffer);
}


/****************************************************************************
**
** FUNCTION:    _gtx_perror
**
** DESCRIPTION: Print a system error using error message function
**
** RETURNS:     None
**
** IN_ARGS:     char
**
** OUT_ARGS:    None
**
*****************************************************************************/
void _gtx_perror(char *format, ...)
{
  va_list ap;
  char buffer[1024];
#if defined(winnt)
  char nterror[1024];
#endif
  char *colnsp, *ptr;

  va_start(ap, format);
  (void)vsnprintf(buffer, sizeof(buffer), format, ap);
  va_end(ap);

#if defined(winnt)
  {
    LPSTR lpMsgBuf;
    int error = GetLastError();
    FormatMessage(
      FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
      NULL,
      error,
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR)&lpMsgBuf,
      0,
      NULL);
    if( lpMsgBuf != NULL ) strcpy(nterror, lpMsgBuf);
    else strcpy(nterror, "");
    /* Free the buffer */
    LocalFree(lpMsgBuf);
    colnsp = ": ";
    ptr = nterror;
  }
#else
  {
    if( (ptr = strerror(errno)) == NULL )
    {
      ptr = "";
      colnsp = "";
    }
    else
      colnsp = ": ";
  }
#endif
  _gtx_error("%s%s%s", buffer, colnsp, ptr);
}

/****************************************************************************
**
** FUNCTION:    _gtx_herror
**
** DESCRIPTION: Print a network error using error message function
**
** RETURNS:     None
**
** IN_ARGS:     char
**
** OUT_ARGS:    None
**
*****************************************************************************/
void _gtx_herror(char *format, ...)
{
  va_list ap;
  char buffer[1024];
  const char *colnsp, *ptr;
#if defined(winnt)
  char nterror[1024];
#endif

  va_start(ap, format);
  (void)vsnprintf(buffer, sizeof(buffer), format, ap);
  va_end(ap);

#if defined(winnt)
  {
    int ws_error = WSAGetLastError();
    int i, nberrcode = sizeof(WSAErrCodes)/sizeof(WSAErrorCode);

    for(i=0; i<nberrcode; i++)
    {
      if( ws_error == WSAErrCodes[i].dcode )
      {
        sprintf(nterror, "Winsock error: %s", WSAErrCodes[i].msg);
        break;
      }
    }
    if( i == nberrcode )
    {
      sprintf(nterror, "Winsock error: %s", WSAErrCodes[0].msg);
    }
    ptr = nterror;
    colnsp = "\n";
  }
#elif !defined(aix)
  {
    if( (ptr = hstrerror(h_errno)) == NULL )
    {
      ptr = "";
      colnsp = "";
    }
    else
      colnsp = ": ";
  }
#else
  {
    switch(h_errno)
    {
      case HOST_NOT_FOUND:
        ptr = "Authoritative Answer Host not found";
        break;
      case TRY_AGAIN:
        ptr = "Non-Authoritive Host not found, or SERVERFAIL";
        break;
      case NO_RECOVERY:
        ptr = "Non recoverable errors, FORMERR, REFUSED, NOTIMP";
        break;
      case NO_DATA:
        ptr = "Valid name, no data record of requested type";
        break;
      default:
        ptr = "";
        break; 
    }
    colnsp = ": ";
  }
#endif
  _gtx_error("%s%s%s", buffer, colnsp, ptr);
}
