/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
#include <GTXClientP.h>
 
static char svnid[] _GTX_UNUSED = "$Id: send_and_receive.c 26586 2016-10-21 15:08:13Z foucher $";

#if !defined(winnt)
#include <unistd.h> /* read() on solaris */
#else
#include <io.h>
#include <stdlib.h>
#include <stdio.h>
#endif
#include <errno.h> /* EBADF on solaris */

#if !defined(winnt)
#include <sys/time.h>     /* getrlimit() on solaris */
#include <sys/resource.h>
#endif

#if defined (aix)
#include <sys/select.h>
#endif

/****************************************************************************
**
** FUNCTION:    _gtx_start_packet
**
** DESCRIPTION: start packet sending
**
** RETURNS:     0 if Ok, 1 elsewhere
**
** IN_ARGS:     type: packet type
**
** OUT_ARGS:    None
**
*****************************************************************************/
int _gtx_start_packet(char *type)
{
  const char *s[1];
  int old;

  GTX_TRACE(2,("Start Packet %s", type));
  _gtx_debug("Sending " DEBUG_COLOR_ON "%s" DEBUG_COLOR_OFF
             " to server.", type);

  s[0] = type;
  old = _gtx_disable_rw_trace;
  _gtx_disable_rw_trace = 1;
  if (!_gtx_write_string(_gtx_server_socket, s, 11))
  {
    _gtx_serror("_gtx_start_packet(): Client/Server communication error");
    _gtx_disable_rw_trace = old;
    return 1;
  }
  _gtx_disable_rw_trace = old;
  return 0;
}

/****************************************************************************
**
** FUNCTION:    _gtx_send_and_wait
**
** DESCRIPTION: send packet and receive returned type
**
** RETURNS:     0 if Ok, 1 elsewhere
**
** OUT_ARGS:    type: returned packet type
**
*****************************************************************************/
int _gtx_send_and_wait(char *type)
{
#if !defined(winnt)
  struct rlimit rlp;
#endif
  fd_set fdset;
  int old,error;
  char *s[1];
  struct timeval timeout;

  error = 1;

  if (!_gtx_flush_write(_gtx_server_socket)) goto label_end;

#if defined(DEBUG)
  timeout.tv_sec = 180; timeout.tv_usec = 0; /* 180s in DEBUG mode */
#else
  timeout.tv_sec = 30; timeout.tv_usec = 0; /* 30s */
#endif
  FD_ZERO(&fdset);
  FD_SET(_gtx_server_socket, &fdset);

  GTX_TRACE(5,("Calling select on socket %d", (int)_gtx_server_socket));
#if defined(winnt)
  if (select(0 /*unused in winsock */, &fdset, NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
#elif defined (aix)
  if (select(howmany(FD_SETSIZE, NFDBITS), &fdset, NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
#else  /* aix */
  (void)getrlimit(RLIMIT_NOFILE, &rlp);
#if defined (hpux)
  if (select((size_t)rlp.rlim_cur, (int*)&fdset, NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
#else  /* hpux */
  if (select((int)rlp.rlim_cur, &fdset, NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
#endif /* !hpux */
#endif /* !aix */
  {
    _gtx_serror("_gtx_send_and_wait(): call to select() failed");
    goto label_end;
  }

  /* check answer from server */
  if (!FD_ISSET(_gtx_server_socket, &fdset))
  {
    _gtx_serror("_gtx_send_and_wait(): Receives nothing from server");
    goto label_end;
  }
#if !defined(winnt)
  if (((int)read(_gtx_server_socket, NULL, 0)) < 0)
  {
    _gtx_serror("_gtx_send_and_wait(): Server has terminated connection");
    goto label_end;
  }
#endif

  GTX_TRACE(5,("Data received on socket. Trying to read string"));
  old = _gtx_disable_rw_trace;
  _gtx_disable_rw_trace = 1;
  s[0] = type;
  if (!_gtx_read_string(_gtx_server_socket, s, 10))
  {
    _gtx_serror("_gtx_send_and_wait(): Client/Server communication error");
    _gtx_disable_rw_trace = old;
    goto label_end;
  }
  _gtx_disable_rw_trace = old;

  error = 0;

label_end:
  if (error)
  { GTX_TRACE(2,("Error during communication")); }
  else
  { GTX_TRACE(2,("Received Packet %s", type)); }

  return error;
}
  
/****************************************************************************
**
** FUNCTION:    _gtx_check_answer
**
** DESCRIPTION: check answered type
**
** RETURNS:     0 if Ok, 1 elsewhere
**
** IN_ARGS:     received_type: received type
** IN_ARGS:     expected_type: expected type
**
** OUT_ARGS:    none
**
*****************************************************************************/
int _gtx_check_answer(char *received_type, char *expected_type)
{
  int error;
  char *error_str;

  error = 1;
  error_str = NULL;

  /* is it an error */
  if (!strcmp(received_type, "SERROR"))
  {
    if (!_gtx_read_string(_gtx_server_socket, &error_str, 10000))
    {
      _gtx_serror("_gtx_check_answer(): Client/Server communication error");
      goto label_end;
    }
    _gtx_error("Server: %s", error_str);
    _gtx_debug("Reply from server = " DEBUG_COLOR_ON "SERROR:%s" DEBUG_COLOR_OFF
               ".", error_str);
    goto label_end;
  }
  else if (!strcmp(received_type, expected_type))
    _gtx_debug("Reply from server = " DEBUG_COLOR_ON "%s" DEBUG_COLOR_OFF
               ".", received_type);
  else
  {
    _gtx_debug("Reply from server = %s.", received_type);
    _gtx_error("Reply from server: " DEBUG_COLOR_ON "\"%s\"" DEBUG_COLOR_OFF
               " where " DEBUG_COLOR_ON "\"%s\"" DEBUG_COLOR_OFF
               " expected.", received_type, expected_type);
    goto label_end;
  }

  error = 0;

label_end:
  if (error_str) free(error_str);

  return error;
}

/****************************************************************************
**
** FUNCTION:    _gtx_cleanup_socket
**
** DESCRIPTION: empty socket and write buffer
**
** RETURNS:     Nothing
**
** IN_ARGS:     None
**
** OUT_ARGS:    None
**
*****************************************************************************/
void _gtx_cleanup_socket(void)
{
  fd_set fdset;
#if !defined(winnt)
  struct rlimit rlp;
#endif
  struct timeval timeout;       /* Time select (sec, usec) */
  int tmp, isset, error, count;

  _gtx_empty_write_buffer();

  if (_gtx_server_socket == _GTX_SOCKET_ERROR) return;
  GTX_TRACE(2,("Cleaning socket..."));

  timeout.tv_sec = 0; timeout.tv_usec = 500000; /* 0.5s */

  FD_ZERO(&fdset);
  FD_SET(_gtx_server_socket, &fdset);

  error = 0;
  count = 0;
  while (1)
  {
    GTX_TRACE(5,("Cheching if there is still data in the socket"));
#if defined(winnt)
    if (select(0 /*unused in winsock */, &fdset,
               NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
      error = 1;
#elif defined (aix)
    if (select(howmany(FD_SETSIZE, NFDBITS), &fdset,
               NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
      error = 1;
#else
    (void)getrlimit(RLIMIT_NOFILE, &rlp);
#if defined (hpux)
    if (select((size_t)rlp.rlim_cur, (int*)&fdset,
               NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
      error = 1;
#else  /* hpux */
    if (select((int)rlp.rlim_cur, &fdset,
               NULL, NULL, &timeout) == _GTX_SOCKET_ERROR)
      error = 1;
#endif /* !hpux */
#endif

    if (error)
    {
      _gtx_serror("_gtx_cleanup_socket(): call to select() failed");
      return;
    }
    isset = (FD_ISSET(_gtx_server_socket, &fdset) != 0);
    if (isset)
    {
      GTX_TRACE(5,("Data present, reading dummy int"));
      if (!_gtx_read_int(_gtx_server_socket, &tmp)) break;
      count++;
    }
    else
      break;
  } /* while there is data in the socket */
  _gtx_debug("Cleaned %d words on the socket.", count);
}
