/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: trace.c 25987 2016-04-26 09:15:49Z foucher $";

#include <time.h>
#ifndef winnt
#include <unistd.h>
#endif
#include <stdarg.h>

int _gtx_trace_level = 0;
FILE * _gtx_trace_file = NULL;
static char date_time[30];
static int last_trace_with_cr = 1;
static int function_level = 0;

/*****************************************************************************
**
** FUNCTION: st_get_pid
**
** PURPOSE:  Return current process id
**
** RETURNS:  int pid: process id
**
*****************************************************************************/
int st_get_pid(void)
{
  int  pid;

#if defined(winnt)
  pid = (int)GetCurrentProcessId();
#else
  pid = (int)getpid();
#endif
  return (pid);
}

/*****************************************************************************
**
** FUNCTION: st_get_date
**
** PURPOSE:  Get the current date
**
** RETURNS:  pointer on static char containing date
**
*****************************************************************************/
char *st_get_date(void)
{
  time_t clock = time(NULL);

#if defined (winnt)
  (void)strftime(date_time, 30, "%b %d %Y", localtime(&clock));
#else
  (void)strftime(date_time, 30, "%h %d %Y", localtime(&clock));
#endif
  return(date_time);
}

/*****************************************************************************
**
** FUNCTION: st_get_time
**
** PURPOSE:  Get the current time
**
** RETURNS:  pointer on static char containing time
**
*****************************************************************************/
char *st_get_time(void)
{
  time_t clock = time(NULL);

#if defined (winnt)
  (void)strftime(date_time, 30, "%X", localtime(&clock));
#else
  (void)strftime(date_time, 30, "%T", localtime(&clock));
#endif
  return(date_time);
}

/****************************************************************************
**
** FUNCTION: _gtx_trace_init
**
** PURPOSE:  Initialize the tracing system
**
*****************************************************************************/
void _gtx_trace_init(void)
{
  char *env,*ptr;
  int trace_level;
  char trace_file_name[200];
  static int trace_initialized = 0;

  if (trace_initialized) return;
  trace_initialized = 1;
  env = getenv("GTX_SERVER_TRACE");
  if (env == NULL) return;

  trace_level = strtol(env, &ptr, 10);
  if (trace_level <= 0) return;

  /* get/compute file name */
  if (_gtx_is_server)
    env = getenv("GTX_SERVER_TRACE_FILE");
  else
    env = getenv("GTX_CLIENT_TRACE_FILE");
  if (env != NULL)
  {
    (void)strncpy(trace_file_name, env, 200);
    trace_file_name[199] = '\0';
  }
  else
  {
#ifdef winnt
    (void)strcpy(trace_file_name, "C:\\");
#else
    (void)strcpy(trace_file_name, "/tmp/");
#endif
    (void)sprintf(&trace_file_name[strlen(trace_file_name)],
                  "%s_trace_%d.txt",
                  (_gtx_is_server)? "GTXserver" : "GTXClient",
                  st_get_pid());
  }
  
  if (_gtx_trace_file != NULL)
    (void)fclose(_gtx_trace_file);
  _gtx_trace_file = NULL;

  /* open file */
  _gtx_trace_file = fopen(trace_file_name, "a");
  if (_gtx_trace_file == NULL)
    _gtx_trace_level = 0;
  else
    _gtx_trace_level = trace_level;

  GTX_TRACE(0, ("Tracing %s. Level %d. Date %s",
                (_gtx_is_server)? "GTXserver" : "GTXClient",
                trace_level, st_get_date()));
}

/****************************************************************************
**
** FUNCTION: _gtx_trace
**
** PURPOSE:  Adds a message to the current trace file
**
** IN_ARGS:  format: format ala printf
**
*****************************************************************************/
void _gtx_trace(char *format, ...)
{
  va_list ap;
  char indent[11],buffer[1024];
 
  if (_gtx_trace_file == NULL) return;

  va_start(ap, format);
  (void)vsnprintf(buffer, sizeof(format), format, ap);
  va_end(ap);
 
  if (last_trace_with_cr)
  {
    (void)strcpy(indent,"          ");
    if (function_level > 5)
    {
      (void)fprintf(_gtx_trace_file, "%s: Error in debug print (wrong indent) !!!!!!\n", st_get_time());
      function_level = 5;
      }
    indent[2*function_level] = '\0';
    (void)fprintf(_gtx_trace_file, "%s: %s%s\n",
                  st_get_time(), indent,buffer);
  }
  else
    (void)fprintf(_gtx_trace_file, "%s\n", buffer);
  (void)fflush(_gtx_trace_file);
  last_trace_with_cr = 1;
}

/****************************************************************************
**
** FUNCTION: _gtx_trace_func_start
**
** PURPOSE:  Traces the start of a function
**
** IN_ARGS:  function: name of the function
** IN_ARGS:  args    : 1 if the function has arguments (trace following)
**
*****************************************************************************/
void _gtx_trace_func_start(char *function,
                           int args)
{
  char indent[11];

  if (_gtx_trace_file == NULL) return;
  (void)strcpy(indent,"          ");
  indent[2*function_level] = '\0';

  (void)fprintf(_gtx_trace_file, "%s: %sFunction %s%s",
                st_get_time(), indent, function,
                (args)? "": "\n");

  (void)fflush(_gtx_trace_file);
  last_trace_with_cr = !args;
  function_level++;
  if (function_level > 5)
  {
    (void)fprintf(_gtx_trace_file, "%s: Error in debug print (wrong indent) !!!!!!\n", st_get_time());
    function_level = 5;
  }
}

/****************************************************************************
**
** FUNCTION: _gtx_trace_func_end
**
** PURPOSE:  Traces the end of a function
**
** IN_ARGS:  format: formatted returned value
**
*****************************************************************************/
void _gtx_trace_func_end(char *format, ...)
{
  va_list ap;
  char fmt[50], indent[11];

  if (_gtx_trace_file == NULL) return;

  function_level--;
  if (function_level < 0)
  {
    (void)fprintf(_gtx_trace_file, "%s: Error in debug print (wrong indent) !!!!!!\n", st_get_time());
    function_level = 0;
  }
  (void)strcpy(indent,"          ");
  indent[2*function_level] = '\0';
  (void)sprintf(fmt, "%s: ", st_get_time());
  (void)strcat(fmt, indent);

  va_start(ap, format);

  if (format == NULL)
    (void)sprintf(&fmt[strlen(fmt)], "Function returned\n");
  else
    (void)sprintf(&fmt[strlen(fmt)], "Function returned %s\n", format);

  (void)vfprintf(_gtx_trace_file, fmt, ap);
  (void)fflush(_gtx_trace_file);
  last_trace_with_cr = 1;
  va_end(ap);
}

/****************************************************************************
**
** FUNCTION: _gtx_trace_end
**
** PURPOSE:  Closes trace file
**
*****************************************************************************/
void _gtx_trace_end(void)
{
  if (_gtx_trace_file != NULL)
    (void)fclose(_gtx_trace_file);
  _gtx_trace_file = NULL;
  _gtx_trace_level = 0;
}
