/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace com.geovariances.gtxclient {

using System;
using System.Runtime.InteropServices;

class GTXClientWrapperPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("GTXClient_debug", EntryPoint="SWIGRegisterExceptionCallbacks_GTXClientWrapper")]
    public static extern void SWIGRegisterExceptionCallbacks_GTXClientWrapper(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("GTXClient_debug", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_GTXClientWrapper")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_GTXClientWrapper(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_GTXClientWrapper(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_GTXClientWrapper(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(GTXClientWrapperPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(GTXClientWrapperPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("GTXClient_debug", EntryPoint="SWIGRegisterStringCallback_GTXClientWrapper")]
    public static extern void SWIGRegisterStringCallback_GTXClientWrapper(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_GTXClientWrapper(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  static GTXClientWrapperPINVOKE() {
  }


  class CustomExceptionHelper {
    // C# delegate for the C/C++ customExceptionCallback
    public delegate void CustomExceptionDelegate(string message);
    static CustomExceptionDelegate customDelegate =
                                   new CustomExceptionDelegate(SetPendingCustomException);

    [DllImport("GTXClient_debug", EntryPoint="CustomExceptionRegisterCallback")]
    public static extern
           void CustomExceptionRegisterCallback(CustomExceptionDelegate customCallback);

    static void SetPendingCustomException(string message) {
      SWIGPendingException.Set(new GTXError(message));
    }

    static CustomExceptionHelper() {
      CustomExceptionRegisterCallback(customDelegate);
    }
  }
  static CustomExceptionHelper exceptionHelper = new CustomExceptionHelper();


  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXByteArray__SWIG_0")]
  public static extern IntPtr new_GTXByteArray__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXByteArray__SWIG_1")]
  public static extern IntPtr new_GTXByteArray__SWIG_1(int jarg1, byte[] jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXByteArray")]
  public static extern void delete_GTXByteArray(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXByteArray__SWIG_2")]
  public static extern IntPtr new_GTXByteArray__SWIG_2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXByteArray_GetCount")]
  public static extern int GTXByteArray_GetCount(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXByteArray_Resize")]
  public static extern void GTXByteArray_Resize(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXByteArray_GetValue")]
  public static extern byte GTXByteArray_GetValue(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXByteArray_SetValue")]
  public static extern void GTXByteArray_SetValue(HandleRef jarg1, int jarg2, byte jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXByteArray_GetValues")]
  public static extern IntPtr GTXByteArray_GetValues(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXClient")]
  public static extern IntPtr new_GTXClient();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetDebugMode")]
  public static extern void GTXClient_SetDebugMode(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetDefaultPort")]
  public static extern ushort GTXClient_GetDefaultPort(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LocateGTXserver")]
  public static extern string GTXClient_LocateGTXserver(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetGTXserverPath")]
  public static extern void GTXClient_SetGTXserverPath(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_RunGTXserver")]
  public static extern ushort GTXClient_RunGTXserver(HandleRef jarg1, ushort jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_Connect")]
  public static extern void GTXClient_Connect(HandleRef jarg1, string jarg2, ushort jarg3, string jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_IsConnected")]
  public static extern bool GTXClient_IsConnected(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_Disconnect")]
  public static extern void GTXClient_Disconnect(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetServerVersion")]
  public static extern int GTXClient_GetServerVersion(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetStudyList")]
  public static extern IntPtr GTXClient_GetStudyList(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetStudy")]
  public static extern void GTXClient_SetStudy(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewStudy")]
  public static extern void GTXClient_NewStudy(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_DeleteStudy")]
  public static extern void GTXClient_DeleteStudy(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetDirectoryList")]
  public static extern IntPtr GTXClient_GetDirectoryList(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_DirectoryExists")]
  public static extern bool GTXClient_DirectoryExists(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetDirectory")]
  public static extern void GTXClient_SetDirectory(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewDirectory")]
  public static extern void GTXClient_NewDirectory(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_DeleteDirectory")]
  public static extern void GTXClient_DeleteDirectory(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetFileList__SWIG_0")]
  public static extern IntPtr GTXClient_GetFileList__SWIG_0(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetFileList__SWIG_1")]
  public static extern IntPtr GTXClient_GetFileList__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_FileExists")]
  public static extern bool GTXClient_FileExists(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetFile")]
  public static extern void GTXClient_SetFile(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_DeleteFile")]
  public static extern void GTXClient_DeleteFile(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetFileInfo")]
  public static extern IntPtr GTXClient_GetFileInfo(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetFileComment")]
  public static extern string GTXClient_GetFileComment(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetFileComment")]
  public static extern void GTXClient_SetFileComment(HandleRef jarg1, bool jarg2, string jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewPointsFile2D")]
  public static extern void GTXClient_NewPointsFile2D(HandleRef jarg1, string jarg2, int jarg3, double[] jarg4, double[] jarg5);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewPointsFile3D")]
  public static extern void GTXClient_NewPointsFile3D(HandleRef jarg1, string jarg2, int jarg3, double[] jarg4, double[] jarg5, double[] jarg6);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewGridFile2D")]
  public static extern void GTXClient_NewGridFile2D(HandleRef jarg1, string jarg2, double jarg3, double jarg4, double jarg5, double jarg6, int jarg7, int jarg8);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewGridFile3D")]
  public static extern void GTXClient_NewGridFile3D(HandleRef jarg1, string jarg2, double jarg3, double jarg4, double jarg5, double jarg6, double jarg7, double jarg8, int jarg9, int jarg10, int jarg11);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewLinesFile")]
  public static extern void GTXClient_NewLinesFile(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_PointsFileAppend2D")]
  public static extern void GTXClient_PointsFileAppend2D(HandleRef jarg1, int jarg2, double[] jarg3, double[] jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_PointsFileAppend3D")]
  public static extern void GTXClient_PointsFileAppend3D(HandleRef jarg1, int jarg2, double[] jarg3, double[] jarg4, double[] jarg5);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileAddLineCores2DOld")]
  public static extern void GTXClient_LinesFileAddLineCores2DOld(HandleRef jarg1, int jarg2, double jarg3, double jarg4, double[] jarg5, double[] jarg6);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileAddLineCores3DOld")]
  public static extern void GTXClient_LinesFileAddLineCores3DOld(HandleRef jarg1, int jarg2, double jarg3, double jarg4, double jarg5, double[] jarg6, double[] jarg7, double[] jarg8);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileAddCoreLine2D")]
  public static extern void GTXClient_LinesFileAddCoreLine2D(HandleRef jarg1, int jarg2, double jarg3, double jarg4, double[] jarg5, double[] jarg6);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileAddCoreLine3D")]
  public static extern void GTXClient_LinesFileAddCoreLine3D(HandleRef jarg1, int jarg2, double jarg3, double jarg4, double jarg5, double[] jarg6, double[] jarg7, double[] jarg8);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileAddGravityLine2D")]
  public static extern void GTXClient_LinesFileAddGravityLine2D(HandleRef jarg1, int jarg2, double[] jarg3, double[] jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileAddGravityLine3D")]
  public static extern void GTXClient_LinesFileAddGravityLine3D(HandleRef jarg1, int jarg2, double[] jarg3, double[] jarg4, double[] jarg5);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_LinesFileCreateLink")]
  public static extern void GTXClient_LinesFileCreateLink(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GridModifyOrigin")]
  public static extern void GTXClient_GridModifyOrigin(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GridModifyMesh")]
  public static extern void GTXClient_GridModifyMesh(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GridModifyRotation")]
  public static extern void GTXClient_GridModifyRotation(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetVariableList__SWIG_0")]
  public static extern IntPtr GTXClient_GetVariableList__SWIG_0(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetVariableList__SWIG_1")]
  public static extern IntPtr GTXClient_GetVariableList__SWIG_1(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_VariableExists")]
  public static extern bool GTXClient_VariableExists(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetVariable")]
  public static extern void GTXClient_SetVariable(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_DeleteVariable")]
  public static extern void GTXClient_DeleteVariable(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetIndice")]
  public static extern void GTXClient_SetIndice(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetAlphaIndice")]
  public static extern void GTXClient_SetAlphaIndice(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetVariableInfo")]
  public static extern IntPtr GTXClient_GetVariableInfo(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetMacroIndices")]
  public static extern IntPtr GTXClient_GetMacroIndices(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetMacroAlphaIndices")]
  public static extern IntPtr GTXClient_GetMacroAlphaIndices(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_AddMacroIndicesWithAlpha")]
  public static extern void GTXClient_AddMacroIndicesWithAlpha(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_AddMacroIndices")]
  public static extern void GTXClient_AddMacroIndices(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadCharVariable")]
  public static extern IntPtr GTXClient_ReadCharVariable(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadCharVariableSub")]
  public static extern IntPtr GTXClient_ReadCharVariableSub(HandleRef jarg1, int jarg2, int jarg3, bool jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadLineCharVariable")]
  public static extern IntPtr GTXClient_ReadLineCharVariable(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadLineDoubleVariable")]
  public static extern IntPtr GTXClient_ReadLineDoubleVariable(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadDoubleVariable")]
  public static extern IntPtr GTXClient_ReadDoubleVariable(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadDoubleVariableSub")]
  public static extern IntPtr GTXClient_ReadDoubleVariableSub(HandleRef jarg1, int jarg2, int jarg3, bool jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadSelectionVariable")]
  public static extern IntPtr GTXClient_ReadSelectionVariable(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadSelectionVariableSub")]
  public static extern IntPtr GTXClient_ReadSelectionVariableSub(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewDoubleVariable")]
  public static extern void GTXClient_NewDoubleVariable(HandleRef jarg1, string jarg2, int jarg3, HandleRef jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewCharVariable")]
  public static extern void GTXClient_NewCharVariable(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetVariableAsLineName")]
  public static extern void GTXClient_SetVariableAsLineName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteDoubleVariable")]
  public static extern void GTXClient_WriteDoubleVariable(HandleRef jarg1, bool jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteDoubleVariableSub")]
  public static extern void GTXClient_WriteDoubleVariableSub(HandleRef jarg1, int jarg2, int jarg3, bool jarg4, HandleRef jarg5);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteLineDoubleVariable")]
  public static extern void GTXClient_WriteLineDoubleVariable(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteCharVariable")]
  public static extern void GTXClient_WriteCharVariable(HandleRef jarg1, bool jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteCharVariableSub")]
  public static extern void GTXClient_WriteCharVariableSub(HandleRef jarg1, int jarg2, int jarg3, bool jarg4, HandleRef jarg5);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteLineCharVariable")]
  public static extern void GTXClient_WriteLineCharVariable(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteSelectionVariableSub")]
  public static extern void GTXClient_WriteSelectionVariableSub(HandleRef jarg1, int jarg2, int jarg3, HandleRef jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteSelectionVariable")]
  public static extern void GTXClient_WriteSelectionVariable(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_GetVariableComment")]
  public static extern string GTXClient_GetVariableComment(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetVariableComment")]
  public static extern void GTXClient_SetVariableComment(HandleRef jarg1, bool jarg2, string jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetSelection")]
  public static extern void GTXClient_SetSelection(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetVariableUnit")]
  public static extern void GTXClient_SetVariableUnit(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetUnit")]
  public static extern void GTXClient_SetUnit(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_UnitFactorFromSymbol")]
  public static extern double GTXClient_UnitFactorFromSymbol(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_UnitSymbolFromFactor")]
  public static extern string GTXClient_UnitSymbolFromFactor(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetUnitMode")]
  public static extern void GTXClient_SetUnitMode(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_SetCreationUnits")]
  public static extern void GTXClient_SetCreationUnits(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_VendorDataWrite")]
  public static extern void GTXClient_VendorDataWrite(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_VendorDataRead")]
  public static extern IntPtr GTXClient_VendorDataRead(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_VendorDataExists")]
  public static extern bool GTXClient_VendorDataExists(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_VendorDataGetVersion")]
  public static extern int GTXClient_VendorDataGetVersion(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadFaults")]
  public static extern IntPtr GTXClient_ReadFaults(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_WriteFaults")]
  public static extern void GTXClient_WriteFaults(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewPolygonsFile")]
  public static extern void GTXClient_NewPolygonsFile(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadPolygons")]
  public static extern IntPtr GTXClient_ReadPolygons(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_NewWireframesFile")]
  public static extern void GTXClient_NewWireframesFile(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXClient_ReadWireframes")]
  public static extern IntPtr GTXClient_ReadWireframes(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXClient")]
  public static extern void delete_GTXClient(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXDoubleArray__SWIG_0")]
  public static extern IntPtr new_GTXDoubleArray__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXDoubleArray__SWIG_1")]
  public static extern IntPtr new_GTXDoubleArray__SWIG_1(int jarg1, double[] jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXDoubleArray")]
  public static extern void delete_GTXDoubleArray(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXDoubleArray__SWIG_2")]
  public static extern IntPtr new_GTXDoubleArray__SWIG_2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleArray_GetCount")]
  public static extern int GTXDoubleArray_GetCount(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleArray_Resize")]
  public static extern void GTXDoubleArray_Resize(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleArray_GetValue")]
  public static extern double GTXDoubleArray_GetValue(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleArray_GetValues")]
  public static extern IntPtr GTXDoubleArray_GetValues(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleArray_SetValue")]
  public static extern void GTXDoubleArray_SetValue(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleArray_SetValues")]
  public static extern void GTXDoubleArray_SetValues(HandleRef jarg1, double[] jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFault__SWIG_0")]
  public static extern IntPtr new_GTXFault__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFault__SWIG_1")]
  public static extern IntPtr new_GTXFault__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXFault")]
  public static extern void delete_GTXFault(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_GetName")]
  public static extern string GTXFault_GetName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_GetPolygonalFlag")]
  public static extern bool GTXFault_GetPolygonalFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_GetSegmentsNumber")]
  public static extern int GTXFault_GetSegmentsNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_GetSegment")]
  public static extern IntPtr GTXFault_GetSegment(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_SetName")]
  public static extern void GTXFault_SetName(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_SetPolygonalFlag")]
  public static extern void GTXFault_SetPolygonalFlag(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFault_AddFaultSegment")]
  public static extern void GTXFault_AddFaultSegment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFaultInfo__SWIG_0")]
  public static extern IntPtr new_GTXFaultInfo__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFaultInfo__SWIG_1")]
  public static extern IntPtr new_GTXFaultInfo__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetFaults2DFlag")]
  public static extern bool GTXFaultInfo_GetFaults2DFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetAuxiliaryVarUsedFlag")]
  public static extern bool GTXFaultInfo_GetAuxiliaryVarUsedFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetFaultsNumber")]
  public static extern int GTXFaultInfo_GetFaultsNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetSegmentsNumber")]
  public static extern int GTXFaultInfo_GetSegmentsNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetMinimumPriority")]
  public static extern int GTXFaultInfo_GetMinimumPriority(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetMaximumPriority")]
  public static extern int GTXFaultInfo_GetMaximumPriority(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultInfo_GetAuthorizedPriority")]
  public static extern int GTXFaultInfo_GetAuthorizedPriority(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXFaultInfo")]
  public static extern void delete_GTXFaultInfo(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFaultSegment__SWIG_0")]
  public static extern IntPtr new_GTXFaultSegment__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFaultSegment__SWIG_1")]
  public static extern IntPtr new_GTXFaultSegment__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXFaultSegment")]
  public static extern void delete_GTXFaultSegment(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetX1")]
  public static extern double GTXFaultSegment_GetX1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetY1")]
  public static extern double GTXFaultSegment_GetY1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetZ1")]
  public static extern double GTXFaultSegment_GetZ1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetX2")]
  public static extern double GTXFaultSegment_GetX2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetY2")]
  public static extern double GTXFaultSegment_GetY2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetZ2")]
  public static extern double GTXFaultSegment_GetZ2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetX3")]
  public static extern double GTXFaultSegment_GetX3(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetY3")]
  public static extern double GTXFaultSegment_GetY3(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetZ3")]
  public static extern double GTXFaultSegment_GetZ3(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetV1")]
  public static extern double GTXFaultSegment_GetV1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetV2")]
  public static extern double GTXFaultSegment_GetV2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetV3")]
  public static extern double GTXFaultSegment_GetV3(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_GetPriority")]
  public static extern int GTXFaultSegment_GetPriority(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetX1")]
  public static extern void GTXFaultSegment_SetX1(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetY1")]
  public static extern void GTXFaultSegment_SetY1(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetZ1")]
  public static extern void GTXFaultSegment_SetZ1(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetX2")]
  public static extern void GTXFaultSegment_SetX2(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetY2")]
  public static extern void GTXFaultSegment_SetY2(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetZ2")]
  public static extern void GTXFaultSegment_SetZ2(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetX3")]
  public static extern void GTXFaultSegment_SetX3(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetY3")]
  public static extern void GTXFaultSegment_SetY3(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetZ3")]
  public static extern void GTXFaultSegment_SetZ3(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetV1")]
  public static extern void GTXFaultSegment_SetV1(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetV2")]
  public static extern void GTXFaultSegment_SetV2(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetV3")]
  public static extern void GTXFaultSegment_SetV3(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSegment_SetPriority")]
  public static extern void GTXFaultSegment_SetPriority(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFaultSystem__SWIG_0")]
  public static extern IntPtr new_GTXFaultSystem__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFaultSystem__SWIG_1")]
  public static extern IntPtr new_GTXFaultSystem__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXFaultSystem")]
  public static extern void delete_GTXFaultSystem(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_GetFaults2DFlag")]
  public static extern bool GTXFaultSystem_GetFaults2DFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_GetAuxiliaryVarUsedFlag")]
  public static extern bool GTXFaultSystem_GetAuxiliaryVarUsedFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_GetAuxiliaryVarTest")]
  public static extern double GTXFaultSystem_GetAuxiliaryVarTest(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_GetFaultsNumber")]
  public static extern int GTXFaultSystem_GetFaultsNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_GetFault")]
  public static extern IntPtr GTXFaultSystem_GetFault(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_SetFaults2DFlag")]
  public static extern void GTXFaultSystem_SetFaults2DFlag(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_SetAuxiliaryVarUsedFlag")]
  public static extern void GTXFaultSystem_SetAuxiliaryVarUsedFlag(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_SetAuxiliaryVarTest")]
  public static extern void GTXFaultSystem_SetAuxiliaryVarTest(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFaultSystem_AddFault")]
  public static extern void GTXFaultSystem_AddFault(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFileInfo__SWIG_0")]
  public static extern IntPtr new_GTXFileInfo__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXFileInfo__SWIG_1")]
  public static extern IntPtr new_GTXFileInfo__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetFileType")]
  public static extern int GTXFileInfo_GetFileType(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetLinkedFileName")]
  public static extern string GTXFileInfo_GetLinkedFileName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetFaultedFlag")]
  public static extern bool GTXFileInfo_GetFaultedFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetPolygonFlag")]
  public static extern bool GTXFileInfo_GetPolygonFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetDimension")]
  public static extern int GTXFileInfo_GetDimension(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetSampleNumber")]
  public static extern int GTXFileInfo_GetSampleNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetItemNumber")]
  public static extern int GTXFileInfo_GetItemNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridX0")]
  public static extern double GTXFileInfo_GetGridX0(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridY0")]
  public static extern double GTXFileInfo_GetGridY0(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridZ0")]
  public static extern double GTXFileInfo_GetGridZ0(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridDX")]
  public static extern double GTXFileInfo_GetGridDX(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridDY")]
  public static extern double GTXFileInfo_GetGridDY(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridDZ")]
  public static extern double GTXFileInfo_GetGridDZ(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridNX")]
  public static extern int GTXFileInfo_GetGridNX(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridNY")]
  public static extern int GTXFileInfo_GetGridNY(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridNZ")]
  public static extern int GTXFileInfo_GetGridNZ(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridRotatedFlag")]
  public static extern bool GTXFileInfo_GetGridRotatedFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridAngleAroundZ")]
  public static extern double GTXFileInfo_GetGridAngleAroundZ(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridAngleAroundY")]
  public static extern double GTXFileInfo_GetGridAngleAroundY(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetGridAngleAroundX")]
  public static extern double GTXFileInfo_GetGridAngleAroundX(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetSampleNumberVariableName")]
  public static extern string GTXFileInfo_GetSampleNumberVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetLineNameVariableName")]
  public static extern string GTXFileInfo_GetLineNameVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetLineNumberVariableName")]
  public static extern string GTXFileInfo_GetLineNumberVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetRelativeNumberVariableName")]
  public static extern string GTXFileInfo_GetRelativeNumberVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetXCoordinateVariableName")]
  public static extern string GTXFileInfo_GetXCoordinateVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetYCoordinateVariableName")]
  public static extern string GTXFileInfo_GetYCoordinateVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetZCoordinateVariableName")]
  public static extern string GTXFileInfo_GetZCoordinateVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetXCoreBeginVariableName")]
  public static extern string GTXFileInfo_GetXCoreBeginVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetYCoreBeginVariableName")]
  public static extern string GTXFileInfo_GetYCoreBeginVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetZCoreBeginVariableName")]
  public static extern string GTXFileInfo_GetZCoreBeginVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetXCoreEndVariableName")]
  public static extern string GTXFileInfo_GetXCoreEndVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetYCoreEndVariableName")]
  public static extern string GTXFileInfo_GetYCoreEndVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetZCoreEndVariableName")]
  public static extern string GTXFileInfo_GetZCoreEndVariableName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXFileInfo_GetFaultInfo")]
  public static extern IntPtr GTXFileInfo_GetFaultInfo(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXFileInfo")]
  public static extern void delete_GTXFileInfo(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXIntArray__SWIG_0")]
  public static extern IntPtr new_GTXIntArray__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXIntArray__SWIG_1")]
  public static extern IntPtr new_GTXIntArray__SWIG_1(int jarg1, int[] jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXIntArray")]
  public static extern void delete_GTXIntArray(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXIntArray__SWIG_2")]
  public static extern IntPtr new_GTXIntArray__SWIG_2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXIntArray_GetCount")]
  public static extern int GTXIntArray_GetCount(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXIntArray_Resize")]
  public static extern void GTXIntArray_Resize(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXIntArray_GetValue")]
  public static extern int GTXIntArray_GetValue(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXIntArray_SetValue")]
  public static extern void GTXIntArray_SetValue(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXIntArray_GetValues")]
  public static extern IntPtr GTXIntArray_GetValues(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXPolygon__SWIG_0")]
  public static extern IntPtr new_GTXPolygon__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXPolygon__SWIG_1")]
  public static extern IntPtr new_GTXPolygon__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXPolygon")]
  public static extern void delete_GTXPolygon(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetName")]
  public static extern string GTXPolygon_GetName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetGroupName")]
  public static extern string GTXPolygon_GetGroupName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetZMin")]
  public static extern double GTXPolygon_GetZMin(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetZMax")]
  public static extern double GTXPolygon_GetZMax(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetVerticesNumber")]
  public static extern int GTXPolygon_GetVerticesNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetXVertices")]
  public static extern double GTXPolygon_GetXVertices(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_GetYVertices")]
  public static extern double GTXPolygon_GetYVertices(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_SetName")]
  public static extern void GTXPolygon_SetName(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_SetGroupName")]
  public static extern void GTXPolygon_SetGroupName(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_SetZMin")]
  public static extern void GTXPolygon_SetZMin(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_SetZMax")]
  public static extern void GTXPolygon_SetZMax(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygon_AddVertex")]
  public static extern void GTXPolygon_AddVertex(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXPolygonSystem__SWIG_0")]
  public static extern IntPtr new_GTXPolygonSystem__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXPolygonSystem__SWIG_1")]
  public static extern IntPtr new_GTXPolygonSystem__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXPolygonSystem")]
  public static extern void delete_GTXPolygonSystem(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetPolygons2DFlag")]
  public static extern bool GTXPolygonSystem_GetPolygons2DFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetMinimumExtensionX")]
  public static extern double GTXPolygonSystem_GetMinimumExtensionX(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetMinimumExtensionY")]
  public static extern double GTXPolygonSystem_GetMinimumExtensionY(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetMinimumExtensionZ")]
  public static extern double GTXPolygonSystem_GetMinimumExtensionZ(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetMaximumExtensionX")]
  public static extern double GTXPolygonSystem_GetMaximumExtensionX(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetMaximumExtensionY")]
  public static extern double GTXPolygonSystem_GetMaximumExtensionY(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetMaximumExtensionZ")]
  public static extern double GTXPolygonSystem_GetMaximumExtensionZ(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetPolygonsNumber")]
  public static extern int GTXPolygonSystem_GetPolygonsNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_GetPolygon")]
  public static extern IntPtr GTXPolygonSystem_GetPolygon(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_SetPolygons2DFlag")]
  public static extern void GTXPolygonSystem_SetPolygons2DFlag(HandleRef jarg1, bool jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXPolygonSystem_AddPolygon")]
  public static extern void GTXPolygonSystem_AddPolygon(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXStringArray__SWIG_0")]
  public static extern IntPtr new_GTXStringArray__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXStringArray")]
  public static extern void delete_GTXStringArray(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXStringArray__SWIG_1")]
  public static extern IntPtr new_GTXStringArray__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXStringArray_GetCount")]
  public static extern int GTXStringArray_GetCount(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXStringArray_Resize")]
  public static extern void GTXStringArray_Resize(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXStringArray_GetValue")]
  public static extern string GTXStringArray_GetValue(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXStringArray_GetValues")]
  public static extern IntPtr GTXStringArray_GetValues(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXStringArray_SetValue")]
  public static extern void GTXStringArray_SetValue(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXVariableFormat")]
  public static extern IntPtr new_GTXVariableFormat();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_SetType")]
  public static extern void GTXVariableFormat_SetType(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_GetFormatType")]
  public static extern int GTXVariableFormat_GetFormatType(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_SetLength")]
  public static extern void GTXVariableFormat_SetLength(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_GetLength")]
  public static extern int GTXVariableFormat_GetLength(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_SetDigits")]
  public static extern void GTXVariableFormat_SetDigits(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_GetDigits")]
  public static extern int GTXVariableFormat_GetDigits(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_SetUnit")]
  public static extern void GTXVariableFormat_SetUnit(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableFormat_GetUnit")]
  public static extern string GTXVariableFormat_GetUnit(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXVariableFormat")]
  public static extern void delete_GTXVariableFormat(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXVariableInfo__SWIG_0")]
  public static extern IntPtr new_GTXVariableInfo__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXVariableInfo__SWIG_1")]
  public static extern IntPtr new_GTXVariableInfo__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetVariableType")]
  public static extern int GTXVariableInfo_GetVariableType(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetBitLength")]
  public static extern int GTXVariableInfo_GetBitLength(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetAlphaLength")]
  public static extern int GTXVariableInfo_GetAlphaLength(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetImplicitFlag")]
  public static extern bool GTXVariableInfo_GetImplicitFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetIndicesNumber")]
  public static extern int GTXVariableInfo_GetIndicesNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetUnit")]
  public static extern string GTXVariableInfo_GetUnit(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetUnitSymbol")]
  public static extern string GTXVariableInfo_GetUnitSymbol(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVariableInfo_GetLengthFlag")]
  public static extern bool GTXVariableInfo_GetLengthFlag(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXVariableInfo")]
  public static extern void delete_GTXVariableInfo(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXVendorData__SWIG_0")]
  public static extern IntPtr new_GTXVendorData__SWIG_0(string jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXVendorData__SWIG_1")]
  public static extern IntPtr new_GTXVendorData__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXVendorData")]
  public static extern void delete_GTXVendorData(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_AddAttributeInt")]
  public static extern void GTXVendorData_AddAttributeInt(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_AddAttributeDouble")]
  public static extern void GTXVendorData_AddAttributeDouble(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_AddAttributeString")]
  public static extern void GTXVendorData_AddAttributeString(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_AddAttributeIntArray")]
  public static extern void GTXVendorData_AddAttributeIntArray(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_AddAttributeDoubleArray")]
  public static extern void GTXVendorData_AddAttributeDoubleArray(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_AddAttributeStringArray")]
  public static extern void GTXVendorData_AddAttributeStringArray(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetVersion")]
  public static extern int GTXVendorData_GetVersion(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetIdentifier")]
  public static extern string GTXVendorData_GetIdentifier(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetAttributeInt")]
  public static extern int GTXVendorData_GetAttributeInt(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetAttributeDouble")]
  public static extern double GTXVendorData_GetAttributeDouble(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetAttributeString")]
  public static extern string GTXVendorData_GetAttributeString(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetAttributeIntArray")]
  public static extern IntPtr GTXVendorData_GetAttributeIntArray(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetAttributeDoubleArray")]
  public static extern IntPtr GTXVendorData_GetAttributeDoubleArray(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXVendorData_GetAttributeStringArray")]
  public static extern IntPtr GTXVendorData_GetAttributeStringArray(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXWireframe__SWIG_0")]
  public static extern IntPtr new_GTXWireframe__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXWireframe__SWIG_1")]
  public static extern IntPtr new_GTXWireframe__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXWireframe")]
  public static extern void delete_GTXWireframe(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_GetName")]
  public static extern string GTXWireframe_GetName(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_GetColorR")]
  public static extern int GTXWireframe_GetColorR(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_GetColorG")]
  public static extern int GTXWireframe_GetColorG(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_GetColorB")]
  public static extern int GTXWireframe_GetColorB(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_GetObjectsNumber")]
  public static extern int GTXWireframe_GetObjectsNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_GetWireframeObject")]
  public static extern IntPtr GTXWireframe_GetWireframeObject(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_SetName")]
  public static extern void GTXWireframe_SetName(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_SetColorRGB")]
  public static extern void GTXWireframe_SetColorRGB(HandleRef jarg1, int jarg2, int jarg3, int jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframe_AddObject")]
  public static extern void GTXWireframe_AddObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXWireframeObject__SWIG_0")]
  public static extern IntPtr new_GTXWireframeObject__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXWireframeObject__SWIG_1")]
  public static extern IntPtr new_GTXWireframeObject__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXWireframeObject")]
  public static extern void delete_GTXWireframeObject(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetVerticesNumber")]
  public static extern int GTXWireframeObject_GetVerticesNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetVertexX")]
  public static extern double GTXWireframeObject_GetVertexX(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetVertexY")]
  public static extern double GTXWireframeObject_GetVertexY(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetVertexZ")]
  public static extern double GTXWireframeObject_GetVertexZ(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetTrianglesNumber")]
  public static extern int GTXWireframeObject_GetTrianglesNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetTrianglePt1")]
  public static extern int GTXWireframeObject_GetTrianglePt1(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetTrianglePt2")]
  public static extern int GTXWireframeObject_GetTrianglePt2(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_GetTrianglePt3")]
  public static extern int GTXWireframeObject_GetTrianglePt3(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_AddVertex")]
  public static extern void GTXWireframeObject_AddVertex(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeObject_AddTriangle")]
  public static extern void GTXWireframeObject_AddTriangle(HandleRef jarg1, int jarg2, int jarg3, int jarg4);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXWireframeSystem__SWIG_0")]
  public static extern IntPtr new_GTXWireframeSystem__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXWireframeSystem__SWIG_1")]
  public static extern IntPtr new_GTXWireframeSystem__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXWireframeSystem")]
  public static extern void delete_GTXWireframeSystem(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeSystem_GetWireframesNumber")]
  public static extern int GTXWireframeSystem_GetWireframesNumber(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeSystem_GetWireframe")]
  public static extern IntPtr GTXWireframeSystem_GetWireframe(HandleRef jarg1, int jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXWireframeSystem_AddWireframe")]
  public static extern void GTXWireframeSystem_AddWireframe(HandleRef jarg1, HandleRef jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXCharData__SWIG_0")]
  public static extern IntPtr new_GTXCharData__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXCharData")]
  public static extern void delete_GTXCharData(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXCharData__SWIG_1")]
  public static extern IntPtr new_GTXCharData__SWIG_1(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXCharData_GetUndefinedValue")]
  public static extern string GTXCharData_GetUndefinedValue(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXCharData_SetUndefinedValue")]
  public static extern void GTXCharData_SetUndefinedValue(HandleRef jarg1, string jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXDoubleData__SWIG_0")]
  public static extern IntPtr new_GTXDoubleData__SWIG_0();

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXDoubleData__SWIG_1")]
  public static extern IntPtr new_GTXDoubleData__SWIG_1(int jarg1, double[] jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_delete_GTXDoubleData")]
  public static extern void delete_GTXDoubleData(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_new_GTXDoubleData__SWIG_2")]
  public static extern IntPtr new_GTXDoubleData__SWIG_2(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleData_GetUndefinedValue")]
  public static extern double GTXDoubleData_GetUndefinedValue(HandleRef jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleData_SetUndefinedValue")]
  public static extern void GTXDoubleData_SetUndefinedValue(HandleRef jarg1, double jarg2);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXCharData_SWIGUpcast")]
  public static extern IntPtr GTXCharData_SWIGUpcast(IntPtr jarg1);

  [DllImport("GTXClient_debug", EntryPoint="CSharp_GTXDoubleData_SWIGUpcast")]
  public static extern IntPtr GTXDoubleData_SWIGUpcast(IntPtr jarg1);
}

}
